<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

// class RolesAndPermissionsSeeder extends Seeder
// {
//   public function run(): void
//   {
//     $guard = 'web';

//     // 1) Create ONLY the new merchant-related permissions if they don't exist
//     $newPerms = [
//       'merchant.access',
//       'merchant.view_dashboard',
//       'merchant.view_products',
//       'merchant.view_earnings',
//       // add more later if needed
//     ];

//     foreach ($newPerms as $p) {
//       Permission::firstOrCreate(['name' => $p, 'guard_name' => $guard]);
//     }

//     // 2) Ensure roles exist (no changes to their existing permissions)
//     $admin    = Role::findOrCreate('admin', $guard);
//     $merchant = Role::findOrCreate('merchant', $guard);
//     $staff    = Role::findOrCreate('staff', $guard); // stays minimal; grant selectively later

//     // 3) Add the new permissions to admin and merchant (additive, does NOT remove others)
//     $admin->givePermissionTo($newPerms);
//     $merchant->givePermissionTo([
//       'merchant.access',
//       'merchant.view_dashboard',
//       'merchant.view_products',
//       'merchant.view_earnings',
//     ]);

//     // If you want *all* staff to see the Merchant menu by default, uncomment:
//     // $staff->givePermissionTo(['merchant.access']);
//   }
// }


class RolesAndPermissionsSeeder extends Seeder
{
  public function run(): void
  {
    $guard = 'web';

    // Only create merchant-related permissions
    $merchantPerms = [
      'merchant.access',
      'merchant.view_dashboard',  // keep defined, you can choose who actually gets it
      'merchant.view_products',
      'merchant.view_earnings',
      'merchant.manage_profile',  // optional, if you use it
    ];

    foreach ($merchantPerms as $perm) {
      Permission::firstOrCreate(['name' => $perm, 'guard_name' => $guard]);
    }

    // Ensure roles exist
    $admin    = Role::findOrCreate('admin', $guard);
    $merchant = Role::findOrCreate('merchant', $guard);
    $staff    = Role::findOrCreate('staff', $guard);

    // Grant merchant features to admin (admin usually has everything)
    $admin->givePermissionTo($merchantPerms);

    // Grant merchant features to merchant
    // (if you removed the dashboard earlier, just omit 'merchant.view_dashboard' here)
    $merchant->givePermissionTo([
      'merchant.access',
      'merchant.view_products',
      'merchant.view_earnings',
      // 'merchant.view_dashboard', // <— leave commented if you want to retire it
      'merchant.manage_profile',
    ]);

    // Staff: earnings + merchant CRUD (no seller changes here)
    foreach (
      [
        'merchant.view_earnings',
        'show_merchants',
        'add_merchants',
        'edit_merchants',
        'delete_merchants',
        // optional if you want staff to see the Merchant menu header:
        // 'merchant.access',
      ] as $p
    ) {
      Permission::firstOrCreate(['name' => $p, 'guard_name' => $guard]);
    }
    $staff->givePermissionTo([
      'merchant.view_earnings',
      'show_merchants',
      'add_merchants',
      'edit_merchants',
      'delete_merchants',
      // 'merchant.access',
    ]);

    // IMPORTANT: We DO NOT create, sync, or modify any "seller" role or seller permissions here.
  }
}
