@extends('backend.layouts.app')

@section('content')
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="shadow-xl rounded-lg p-4" style="background:#91A8D0">
                <div class="fw-600">{{ translate('Orders') }}</div>
                <div class="d-flex align-items-baseline mt-2">
                    <div class="h3 fw-700 mb-0">{{ $ordersCount }}</div>
                    <div class="ml-3 text-white">
                        {{ translate('Amount:') }}
                        <strong>{{ format_price($ordersAmountAll, true) }}</strong>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="shadow-xl rounded-lg p-4" style="background:#F0C05A">
                <div class="fw-600 ">{{ translate('Completed Orders') }}</div>
                <div class="d-flex align-items-baseline mt-2 ">
                    <div class="h3 fw-700 mb-0">{{ $completedCount }}</div>
                    <div class="ml-3 text-white">
                        {{ translate('Amount:') }}
                        <strong>{{ format_price($gross, true) }}</strong>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Earnings by Product --}}
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6">{{ translate('Earnings by Product') }}</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ translate('Product') }}</th>
                            <th data-breakpoints="xs sm">{{ translate('Qty Sold') }}</th>
                            <th>{{ translate('Gross') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($perProduct as $i => $row)
                            <tr>
                                <td>{{ $perProduct->firstItem() + $i }}</td>
                                <td>{{ optional($row->product)->name }}</td>
                                <td>{{ $row->qty }}</td>
                                <td>{{ format_price($row->gross, true) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted">
                                    {{ translate('No earnings yet.') }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="aiz-pagination">{{ $perProduct->links() }}</div>
        </div>
    </div>

    {{-- Orders (date-range filtered) --}}
    <div class="card mt-4">
        <form id="earnings_orders_filter" method="GET">
            <div class="card-header row gutters-5 align-items-center">
                <div class="col text-center text-md-left">
                    <h5 class="mb-0 h6">{{ translate('Orders') }}</h5>
                </div>

                <div class="col-xl-3 col-md-4 ml-auto">
                    <div class="input-group">
                        <input type="text" class="form-control aiz-date-range" name="date_range"
                            value="{{ $date_range }}" placeholder="{{ translate('Filter by date range') }}"
                            data-format="YYYY-MM-DD" data-separator=" to " autocomplete="off"
                            onchange="document.getElementById('earnings_orders_filter').submit();">
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-primary btn-sm">
                                {{ translate('Filter') }}
                            </button>
                        </div>
                    </div>
                    <small class="text-muted">{{ translate('Shows only items belonging to your products') }}</small>
                </div>
            </div>
        </form>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ translate('Order Code') }}</th>
                            <th data-breakpoints="xs">{{ translate('Num. of Products') }}</th>
                            <th data-breakpoints="xs sm">{{ translate('Customer') }}</th>
                            <th>{{ translate('Amount') }}</th>
                            <th data-breakpoints="xs sm md">{{ translate('Payment Status') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($orders as $k => $order)
                            @php
                                $stat = $orderStats[$order->id] ?? null;
                                $items = $stat->items_count ?? 0;
                                $amount = $stat->amount ?? 0;
                            @endphp
                            <tr>
                                <td>{{ $orders->firstItem() + $k }}</td>

                                <td class="text-nowrap">
                                    <div class="fw-600">
                                        {{ $order->combined_order->code ?? ($order->code ?? '#' . $order->id) }}
                                    </div>
                                    <div class="small opacity-60">{{ $order->created_at->toFormattedDateString() }}</div>
                                </td>

                                <td>{{ $items }}</td>

                                <td>
                                    @if ($order->name)
                                        {{ $order->name }}
                                    @elseif(optional($order->user)->name)
                                        {{ $order->user->name }}
                                    @else
                                        {{ translate('Guest') }}
                                    @endif
                                </td>

                                <td>{{ format_price($amount, true) }}</td>

                                <td>
                                    @if ($order->payment_status === 'paid')
                                        <span class="badge badge-inline badge-success">{{ translate('Paid') }}</span>
                                    @else
                                        <span class="badge badge-inline badge-danger">{{ translate('Unpaid') }}</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted">
                                    {{ translate('No orders found for the selected range.') }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="aiz-pagination">
                {{ $orders->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        function print_invoice(url) {
            var h = $(window).height();
            var w = $(window).width();
            window.open(url, '_blank', 'height=' + h + ',width=' + w + ',scrollbars=yes,status=no');
        }
    </script>
@endsection
