@extends('backend.layouts.app')

@section('content')
    <h1 class="h4 fw-700 mb-3">
        {{ translate('Seller') }}: {{ optional($order->user)->name }}
        <br>
        {{ translate('Order code') }}: {{ optional($order->combined_order)->code }}
    </h1>

    <div class="row gutters-5">
        <div class="col-lg">
            <div class="card">
                <div class="card-header">
                    <h2 class="h2 fs-16 fw-600 mb-0">{{ translate('Order Details') }}</h2>
                </div>

                <div class="card-header">
                    <div class="flex-grow-1 row">
                        <div class="col-md mb-3">
                            <div>
                                <div class="fs-15 fw-600 mb-2">{{ translate('Customer info') }}</div>
                                <div><span class="opacity-80 mr-2 ml-0">{{ translate('Name') }}:</span>
                                    {{ $order->name ?? '' }}</div>
                                <div><span class="opacity-80 mr-2 ml-0">{{ translate('Email') }}:</span>
                                    {{ $order->email ?? '' }}</div>
                                <div><span class="opacity-80 mr-2 ml-0">{{ translate('Phone') }}:</span>
                                    {{ $order->phone ?? '' }}</div>
                            </div>
                        </div>
                        <div class="col-md-6 col-xl-4">
                            <table class="table table-borderless table-sm">
                                <tbody>
                                    <tr>
                                        <td class="">{{ translate('Order code') }}:</td>
                                        <td class="text-right text-info fw-700">
                                            {{ optional($order->combined_order)->code }}</td>
                                    </tr>
                                    <tr>
                                        <td class="">{{ translate('Order Date') }}:</td>
                                        <td class="text-right fw-700">{{ optional($order->created_at)->format('d.m.Y') }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="">{{ translate('Delivery type') }}:</td>
                                        <td class="text-right fw-700">
                                            {{ ucfirst(str_replace('_', ' ', $order->delivery_type ?? '')) }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="">{{ translate('Payment method') }}:</td>
                                        <td class="text-right fw-700">
                                            {{ ucfirst(str_replace('_', ' ', $order->payment_type ?? '')) }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="card-header">
                    <div class="flex-grow-1 row align-items-start">

                        <div class="col-md-3 mr-auto ml-0">
                            <div class="mb-3">
                                <label class="mb-0">{{ translate('Payment Status') }}</label>
                                <select class="form-control aiz-selectpicker" id="update_payment_status"
                                    data-minimum-results-for-search="Infinity" data-selected="{{ $order->payment_status }}"
                                    @if ($order->payment_status == 'paid' || $order->delivery_status == 'cancelled') disabled @endif>
                                    <option value="paid">{{ translate('Paid') }}</option>
                                    <option value="unpaid">{{ translate('Unpaid') }}</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="mb-0">{{ translate('Delivery Status') }}</label>
                                <select class="form-control aiz-selectpicker" id="update_delivery_status"
                                    data-minimum-results-for-search="Infinity"
                                    data-selected="{{ $order->delivery_status }}">
                                    <option value="order packed">{{ translate('Order Packed') }}</option>
                                    <option value="shipped to courier">{{ translate('Shipped To Courier') }}</option>
                                    <option value="in transit">{{ translate('In Transit') }}</option>
                                    <option value="out for delivery">{{ translate('Out for Delivery') }}</option>
                                    <option value="delivered" @if ($order->delivery_status == 'delivered') selected @endif>
                                        {{ translate('Delivered') }}
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-auto w-md-250px">
                            @php
                                $shipping_address = json_decode($order->shipping_address);
                            @endphp
                            <h5 class="fs-14 mb-3">{{ translate('Shipping address') }}</h5>
                            <address class="">
                                {{ $order->shipping_address }}
                            </address>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <table class="aiz-table table-bordered">
                        <thead>
                            <tr class="">
                                <th class="text-center" width="5%" data-breakpoints="lg">#</th>
                                <th width="40%">{{ translate('Product') }}</th>
                                <th class="text-center" data-breakpoints="lg">{{ translate('Qty') }}</th>
                                <th class="text-center" data-breakpoints="lg">{{ translate('Unit Price') }}</th>
                                <th class="text-center" data-breakpoints="lg">{{ translate('Total') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                // Always iterate over a collection to avoid foreach on null
                                $orderDetailsSafe = is_iterable($order->orderDetails ?? null)
                                    ? $order->orderDetails
                                    : collect();
                            @endphp
                            @forelse ($orderDetailsSafe as $key => $orderDetail)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>
                                        @if ($orderDetail->product != null)
                                            <div class="media">
                                                <img src="{{ uploaded_asset($orderDetail->product->thumbnail_img) }}"
                                                    class="size-60px mr-3"
                                                    onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';">
                                                <div class="media-body">
                                                    <h4 class="fs-14 fw-400">{{ $orderDetail->product->name }}</h4>

                                                    @if ($orderDetail->variation)
                                                        @php
                                                            // Make combinations safely iterable (can be array/collection/string/null)
                                                            $combinations = $orderDetail->variation->combinations ?? [];
                                                            if (!is_iterable($combinations)) {
                                                                if (is_string($combinations)) {
                                                                    $decoded = json_decode($combinations, true);
                                                                    $combinations = is_array($decoded) ? $decoded : [];
                                                                } else {
                                                                    $combinations = [];
                                                                }
                                                            }
                                                        @endphp
                                                        @if (!empty($combinations))
                                                            <div>
                                                                @foreach ($combinations as $combination)
                                                                    <span class="mr-2">
                                                                        <span
                                                                            class="opacity-50">{{ optional(data_get($combination, 'attribute', null))->name ?? data_get($combination, 'attribute') }}</span>:
                                                                        {{ optional(data_get($combination, 'attribute_value', null))->name ?? data_get($combination, 'value') }}
                                                                    </span>
                                                                @endforeach
                                                            </div>
                                                        @endif
                                                    @endif
                                                </div>
                                            </div>
                                        @else
                                            <strong>{{ translate('Product Unavailable') }}</strong>
                                        @endif
                                    </td>
                                    <td class="text-center">{{ $orderDetail->quantity }}</td>
                                    <td class="text-center">{{ format_price($orderDetail->price) }}</td>
                                    <td class="text-center">{{ format_price($orderDetail->total) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted">{{ translate('No items.') }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>

                    <div class="row">
                        <div class="col-xl-4 col-md-6 ml-auto mr-0">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td><strong class="">{{ translate('Sub Total') }} :</strong></td>
                                        <td>{{ format_price($orderDetailsSafe->sum('total')) }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong class=""> {{ translate('Shipping') }} :</strong></td>
                                        <td>{{ format_price($order->shipping_cost) }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong class="">{{ translate('TOTAL') }} :</strong></td>
                                        <td class=" h4">
                                            {{ format_price($orderDetailsSafe->sum('total') + ($order->shipping_cost ?? 0)) }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="fs-16 mb-0">{{ translate('Earning History') }}</h3>
                </div>
                <div class="card-body">
                    @php $histories = $order->commission_histories()->latest()->get(); @endphp
                    <table class="table aiz-table mb-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ translate('Seller Earning') }}</th>
                                <th data-breakpoints="lg">{{ translate('Details') }}</th>
                                <th class="text-center">{{ translate('Type') }}</th>
                                <th data-breakpoints="lg" class="text-right">{{ translate('Calculated At') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($histories as $history)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ format_price($history->seller_earning) }}</td>
                                    <td>{{ $history->details }}</td>
                                    <td class="text-center">
                                        @if ($history->details != null)
                                            <span class="badge badge-inline badge-success">Success</span>
                                        @else
                                            <span class="badge badge-inline badge-danger">Failed</span>
                                        @endif
                                    </td>
                                    <td class="text-right">{{ $history->created_at }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted">{{ translate('No history.') }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col col-lg-auto w-lg-300px">
            <div class="card">
                <div class="card-header">
                    <h3 class="fs-16 mb-0">{{ translate('Tracking information') }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('orders.add_tracking_information') }}" method="POST">
                        @csrf
                        <input type="hidden" name="order_id" value="{{ $order->id }}">
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Courier name') }}:</label>
                            <input type="text" class="form-control form-control-sm" name="courier_name"
                                value="{{ $order->courier_name }}" required>
                        </div>
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Tracking number') }}:</label>
                            <input type="text" class="form-control form-control-sm" name="tracking_number"
                                value="{{ $order->tracking_number }}" required>
                        </div>
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Tracking url') }}:</label>
                            <input type="text" class="form-control form-control-sm" name="tracking_url"
                                value="{{ $order->tracking_url }}" required>
                        </div>
                        <div class="text-right">
                            <button class="btn btn-sm btn-primary" type="submit">{{ translate('Save') }}</button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="fs-16 mb-0">{{ translate('Order updates') }}</h3>
                </div>
                <div class="card-body">
                    @php
                        // Prefer correct relation; fall back to legacy; force iterable
                        $updates = $order->order_updates ?? ($order->order_udpates ?? null);
                        $updates = is_iterable($updates) ? $updates : collect();
                    @endphp

                    @forelse ($updates as $order_udpate)
                        <div class="mb-3">
                            <div class="p-2 bg-soft-secondary rounded">
                                {{ $order_udpate->translatable_note ?? false ? translate($order_udpate->note) : $order_udpate->note ?? '' }}
                            </div>
                            <span class="fs-12 opacity-60">
                                {{ translate('by') . ' ' . (optional($order_udpate->user)->name ?? translate('Deleted user')) . ' ' . translate('at') . ' ' . optional($order_udpate->created_at)->format('h:ia, d-m-Y') }}
                            </span>
                        </div>
                    @empty
                        <div class="text-muted fs-13">{{ translate('No updates yet.') }}</div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <!-- Loader overlay -->
    <div id="loader-overlay"
        style="display:none; position:fixed; top:0; left:0; width:100%; height:100%;
                background:rgba(255,255,255,0.6); z-index:9999; text-align:center; padding-top:15%;">
        <div class="spinner-border text-primary" role="status" style="width:3rem;height:3rem;">
            <span class="sr-only">Loading...</span>
        </div>
        <p class="mt-3">{{ translate('Processing, please wait...') }}</p>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        function showLoader() {
            document.getElementById('loader-overlay').style.display = 'block';
        }

        function hideLoader() {
            document.getElementById('loader-overlay').style.display = 'none';
        }

        $('#update_delivery_status').on('change', function() {
            var order_id = {{ $order->id }};
            var status = $('#update_delivery_status').val();

            showLoader();
            $.ajax({
                url: '{{ route('orders.update_delivery_status') }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    order_id: order_id,
                    status: status
                },
                success: function(data) {
                    hideLoader();
                    window.location.reload();
                },
                error: function(xhr) {
                    hideLoader();
                    if (xhr.status === 403) {
                        AIZ.plugins.notify('danger', xhr.responseJSON.error);
                    } else {
                        AIZ.plugins.notify('danger', 'Something went wrong.');
                    }
                }
            });
        });

        $('#update_payment_status').on('change', function() {
            var order_id = {{ $order->id }};
            var status = $('#update_payment_status').val();

            showLoader();
            $.post('{{ route('orders.update_payment_status') }}', {
                _token: '{{ @csrf_token() }}',
                order_id: order_id,
                status: status
            }, function(data) {
                hideLoader();
                window.location.reload();
            }).fail(function(xhr) {
                hideLoader();
                AIZ.plugins.notify('danger', 'Error updating payment status.');
            });
        });
    </script>
@endsection
