@extends('addon:multivendor::seller.layouts.app')

@section('content')
    <div class="container py-5">
        <nav aria-label="breadcrumb" class="mb-3">
            <ol class="breadcrumb bg-transparent px-0 mb-0">
                <li class="breadcrumb-item">
                    <a href="{{ route('seller.dashboard') }}" class="text-decoration-none text-secondary">
                        {{ translate('Dashboard') }}
                    </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">{{ $category->name }}</li>
            </ol>
        </nav>

        <div class="d-flex align-items-center flex-wrap mb-4">
            <h2 class="fw-700 mb-2 mb-lg-0 me-lg-3">{{ $category->name }}</h2>

            <div class="d-grid d-lg-flex gap-2 w-100 w-lg-auto ms-lg-auto">
                {{-- Share this Category --}}
                <a href="#"
                    class="btn btn-outline-secondary border-gray-300 d-flex justify-content-center align-items-center px-3 py-2 bg-warning fw-500 w-100 w-lg-auto copy-category-link"
                    data-user-id="{{ Auth::id() }}" data-category-slug="{{ $category->slug }}" data-placement="bottom"
                    title="{{ translate('Share') }} {{ $category->name }}">
                    <i class="las la-share-alt me-2"></i>{{ translate('Share') }} {{ $category->name }}
                </a>

                {{-- Share My Shop Link --}}
                <a href="#"
                    class="btn btn-outline-secondary border-gray-300 d-flex justify-content-center align-items-center px-3 py-2 bg-warning fw-500 w-100 w-lg-auto copy-shop-link"
                    title="{{ translate('Share My Shop Link') }}">
                    <i class="las la-share-alt me-2"></i>{{ translate('Share My Shop Link') }}
                </a>

                {{-- Share My Referral Link --}}
                <a href="#"
                    class="btn btn-outline-secondary border-gray-300 d-flex justify-content-center align-items-center px-3 py-2 bg-warning fw-500 w-100 w-lg-auto copy-referral-link"
                    title="{{ translate('Share My Referral Link') }}">
                    <i class="las la-network-wired me-2"></i>{{ translate('Share My Referral Link') }}
                </a>
            </div>
        </div>

        {{-- Category Earnings Summary --}}
        <div class="row">
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                    style="background-color:#f5a100">
                    <div class="pb-5">
                        <div class="fw-500 text-white">{{ translate('Current Balance') }}</div>
                        <div class="h2 fw-700 text-white">{{ format_price($currentBalance) }}</div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                    style="background-color:#f5a100">
                    <div class="pb-5">
                        <div class="fw-500 text-white">{{ translate("Today's Earnings") }}</div>
                        <div class="h2 fw-700 text-white">{{ format_price($todayEarnings) }}</div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                    style="background-color:#f5a100">
                    <div class="pb-5">
                        <div class="fw-500 text-white">{{ translate('All-Time Earnings') }}</div>
                        <div class="h2 fw-700 text-white">{{ format_price($allTime) }}</div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                    style="background-color:#f5a100">
                    <div class="pb-5">
                        <div class="fw-500 text-white">{{ translate('Sale Commission') }}</div>
                        <div class="h2 fw-700 text-white">{{ format_price($saleCommision) }}</div>
                    </div>
                </div>
            </div>
        </div>

        @if ($category->banner)
            <div class="mb-4">
                <img src="{{ uploaded_asset($category->banner) }}" alt="{{ $category->name }}" class="img-fluid rounded">
            </div>
        @endif

        @if ($products->count())
            <div class="row">
                @foreach ($products as $product)
                    <div class="col-6 col-md-4 col-lg-3 mb-4">
                        <div class="card h-100 border-0 shadow-sm">
                            <img src="{{ uploaded_asset($product->thumbnail_img) }}" class="card-img-top"
                                alt="{{ $product->name }}">
                            <div class="card-body">
                                <h6 class="fw-600 text-dark mb-1">{{ $product->name }}</h6>
                                <div class="text-primary fw-700 mb-2">{{ format_price($product->lowest_price) }}</div>

                                {{-- Commission badges --}}
                                @php
                                    $fmtPct = function ($v) {
                                        return rtrim(rtrim(number_format((float) $v, 4, '.', ''), '0'), '.') . '%';
                                    };
                                    $fmtVal = function ($t, $v) use ($fmtPct) {
                                        return $t === 'percent' ? $fmtPct($v) : format_price((float) $v) . '/qty';
                                    };
                                @endphp

                                <div class="mb-2">
                                    {{-- Reseller --}}
                                    @if (!empty($product->eff_reseller['type']))
                                        <div class="small d-flex align-items-center mb-1">
                                            <span class="badge badge-soft-primary mr-2">Reseller</span>
                                            <span class="text-muted">
                                                {{ $fmtVal($product->eff_reseller['type'], $product->eff_reseller['value']) }}
                                            </span>
                                            @if ($product->eff_reseller['source'] === 'override')
                                                <span class="badge badge-soft-warning ml-2">Override</span>
                                            @endif
                                        </div>
                                    @endif

                                    {{-- Referral Sale --}}
                                    @if (!empty($product->eff_referral['type']))
                                        <div class="small d-flex align-items-center mb-1">
                                            <span class="badge badge-soft-info mr-2">Referral</span>
                                            <span class="text-muted">
                                                {{ $fmtVal($product->eff_referral['type'], $product->eff_referral['value']) }}
                                            </span>
                                            @if ($product->eff_referral['source'] === 'override')
                                                <span class="badge badge-soft-warning ml-2">Override</span>
                                            @endif
                                        </div>
                                    @endif

                                    {{-- Area Bonus --}}
                                    @if (!empty($product->eff_area['type']))
                                        <div class="small d-flex align-items-center">
                                            <span class="badge badge-soft-success mr-2">Area</span>
                                            <span class="text-muted">
                                                {{ $fmtVal($product->eff_area['type'], $product->eff_area['value']) }}
                                            </span>
                                            @if ($product->eff_area['source'] === 'override')
                                                <span class="badge badge-soft-warning ml-2">Override</span>
                                            @endif
                                        </div>
                                    @endif
                                </div>

                                <a href="{{ route('seller.product.show', $product->id) }}"
                                    class="btn btn-sm btn-outline-primary w-100 mb-2">
                                    {{ translate('View Product') }}
                                </a>

                                <a href="#"
                                    class="btn btn-sm btn-outline-secondary border-gray-300 d-flex align-items-center justify-content-center w-100 bg-warning fw-500 copy-product-link"
                                    data-user-id="{{ Auth::id() }}" data-product-slug="{{ $product->slug }}"
                                    data-placement="bottom" title="{{ translate('Share Product') }}">
                                    <i class="las la-share-alt"></i>&nbsp;{{ translate('Share Product') }}
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="mt-4">
                {{ $products->links() }}
            </div>
        @else
            <div class="alert alert-info">{{ translate('No products found in this category.') }}</div>
        @endif
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        // Robust base URL: prefer HOMEPAGE_URL, fall back to APP_URL/config(app.url), else current host
        const BASE_URL = "{{ rtrim(env('HOMEPAGE_URL', config('app.url') ?: url('/')), '/') }}";

        function copyTextToClipboard(text) {
            if (navigator.clipboard && window.isSecureContext) {
                return navigator.clipboard.writeText(text);
            }
            return new Promise((resolve, reject) => {
                try {
                    const ta = document.createElement('textarea');
                    ta.value = text;
                    ta.style.position = 'fixed';
                    ta.style.opacity = '0';
                    document.body.appendChild(ta);
                    ta.focus();
                    ta.select();
                    const ok = document.execCommand('copy');
                    document.body.removeChild(ta);
                    ok ? resolve() : reject(new Error('execCommand failed'));
                } catch (e) {
                    reject(e);
                }
            });
        }

        // EXACT formats:
        // Product:  https://asensohubph.com/product/{slug}/
        // Category: https://asensohubph.com/product-category/{slug}?sellerid={userId}
        // Shop:     https://asensohubph.com/shop/
        // Referral: https://asensohubph.com/referral/

        function copyProductLink(slug) {
            const url = BASE_URL + "/product/" + slug + "/";
            return copyTextToClipboard(url)
                .then(() => {
                    $.get("{{ route('link.copied') }}");
                    AIZ.plugins.notify('success', 'Product link copied successfully!');
                })
                .catch(err => {
                    console.error("Failed to copy:", err);
                    AIZ.plugins.notify('danger', 'Failed to copy link.');
                });
        }

        function copyCategoryLink(userId, slug) {
            const url = BASE_URL + "/product-category/" + slug + "?sellerid=" + userId;
            return copyTextToClipboard(url)
                .then(() => {
                    $.get("{{ route('link.copied') }}");
                    AIZ.plugins.notify('success', 'Category link copied successfully!');
                })
                .catch(err => {
                    console.error("Failed to copy:", err);
                    AIZ.plugins.notify('danger', 'Failed to copy link.');
                });
        }

        function copyShopLink() {
            const url = BASE_URL + "/shop/";
            return copyTextToClipboard(url)
                .then(() => {
                    $.get("{{ route('link.copied') }}");
                    AIZ.plugins.notify('success', 'Shop link copied successfully!');
                })
                .catch(err => {
                    console.error("Failed to copy:", err);
                    AIZ.plugins.notify('danger', 'Failed to copy link.');
                });
        }

        function copyReferralLink() {
            const url = BASE_URL + "/referral/";
            return copyTextToClipboard(url)
                .then(() => {
                    $.get("{{ route('link.copied') }}");
                    AIZ.plugins.notify('success', 'Referral link copied successfully!');
                })
                .catch(err => {
                    console.error("Failed to copy:", err);
                    AIZ.plugins.notify('danger', 'Failed to copy link.');
                });
        }

        $(document).ready(function() {
            $(document).on('click', '.copy-product-link', function(e) {
                e.preventDefault();
                const slug = $(this).data('product-slug');
                copyProductLink(slug);
            });

            $(document).on('click', '.copy-category-link', function(e) {
                e.preventDefault();
                copyCategoryLink($(this).data('user-id'), $(this).data('category-slug'));
            });

            $(document).on('click', '.copy-shop-link', function(e) {
                e.preventDefault();
                copyShopLink();
            });

            $(document).on('click', '.copy-referral-link', function(e) {
                e.preventDefault();
                copyReferralLink();
            });
        });
    </script>
@endsection
