{{-- resources/views/backend/product/products/edit.blade.php --}}
@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar text-left mt-2 mb-3">
        <h5 class="mb-0 h6">{{ translate('Edit Product') }}</h5>
    </div>

    <form class="form form-horizontal mar-top" action="{{ route('product.update', $product->id) }}" method="POST"
        enctype="multipart/form-data" id="product_form">
        @csrf
        @method('PUT')
        <input type="hidden" name="id" value="{{ $product->id }}">

        <div class="row gutters-5">
            <div class="col-lg">
                {{-- Product Information --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product Information') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Product Name') }}</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="name"
                                    placeholder="{{ translate('Product Name') }}" value="{{ $product->name }}" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Unit') }}</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="unit"
                                    placeholder="{{ translate('Unit (e.g. 500 Gram, 2 Litre, 5 Pc etc)') }}"
                                    value="{{ $product->unit }}">
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Product Images --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product Images') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">
                                {{ translate('Thumbnail Image') }} <small>(300x300)</small>
                            </label>
                            <div class="col-md-8">
                                <div class="input-group" data-toggle="aizuploader" data-type="image" data-mu>
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">
                                            {{ translate('Browse') }}
                                        </div>
                                    </div>
                                    <div class="form-control file-amount">
                                        {{ translate('Choose File') }}
                                    </div>
                                    <input type="hidden" name="thumbnail_img" class="selected-files"
                                        value="{{ $product->thumbnail_img }}">
                                </div>
                                <div class="file-preview box sm"></div>
                                <small class="text-muted">
                                    {{ translate('This image is visible in all product box. Use 300x300 sizes image. Keep some blank space around the main object of your image as we had to crop some edge in different devices to make it responsive.') }}
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Product price, stock --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product price, stock') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="no_product_variant">
                            <div class="form-group row">
                                <label class="col-md-3 col-from-label">
                                    {{ translate('Regular price') }} <span class="text-danger">*</span>
                                </label>
                                <div class="col-md-8">
                                    <input type="number" step="0.01" min="0"
                                        value="{{ $product->lowest_price }}" placeholder="{{ translate('Price') }}"
                                        name="price" class="form-control" required>
                                </div>
                            </div>

                            {{-- SKU removed --}}

                            <div class="form-group row">
                                <label class="col-md-3 col-from-label">
                                    {{ translate('Stock') }} <span class="text-danger">*</span>
                                </label>
                                <div class="col-md-8">
                                    <select class="form-control aiz-selectpicker" name="stock"
                                        data-selected="{{ $product->stock }}">
                                        <option value="1">{{ translate('In stock') }}</option>
                                        <option value="0">{{ translate('Out of stock') }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        {{-- Variant product block kept disabled --}}
                        {{-- ... --}}
                    </div>
                </div>

                {{-- Product Description --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product Description') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Description') }}</label>
                            <div class="col-md-8">
                                <textarea class="aiz-text-editor" name="description">{!! $product->description !!}</textarea>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Attributes / SEO / others kept commented as in original --}}
            </div>

            <div class="col col-lg-auto w-lg-300px w-xxl-400px">
                {{-- Product Status --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product Status') }}</h5>
                    </div>
                    <div class="card-body">
                        <select class="form-control aiz-selectpicker" name="status"
                            data-selected="{{ $product->published }}">
                            <option value="0">{{ translate('Draft') }}</option>
                            <option value="1">{{ translate('Published') }}</option>
                        </select>
                    </div>
                </div>

                {{-- Category tree / Brand / Tags etc kept commented out --}}
            </div>
        </div>

        <div class="mar-all text-right mb-3">
            <button type="submit" class="btn btn-primary" id="upload-product">
                {{ translate('Update Product') }}
            </button>
        </div>
    </form>
@endsection

@section('script')
    <!-- Treeview js -->
    <script src="{{ static_asset('assets/js/hummingbird-treeview.js') }}"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('.all-attributes')
                .find('.attr-names')
                .find('.aiz-selectpicker')
                .siblings('.dropdown-toggle')
                .addClass("disabled");

            if (
                $('.customer_choice_options')
                .find('.attr-names')
                .find('.aiz-selectpicker')
                .val() !== ''
            ) {
                $('.customer_choice_options')
                    .find('.attr-names')
                    .find('.aiz-selectpicker')
                    .siblings('.dropdown-toggle')
                    .addClass("disabled");
            }
        });

        $('#product_form').bind('submit', function(e) {
            $("#upload-product").prop('disabled', true);
            var valid = true;
            if (!valid) {
                e.preventDefault();
                $("#upload-product").prop('disabled', false);
            }
        });

        function update_sku() {
            $.ajax({
                type: "POST",
                url: '{{ route('product.sku_combination') }}',
                data: $('#product_form').serialize(),
                success: function(data) {
                    $('#sku_combination').html(data);
                    setTimeout(() => {
                        AIZ.uploader.previewGenerate();
                        AIZ.plugins.bootstrapSelect('refresh');
                    }, 500);
                }
            });
        }
    </script>
@endsection
