@extends('backend.layouts.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-lg-auto">
                    <img src="{{ uploaded_asset($product->thumbnail_img) }}" class="size-200px">
                </div>
                <div class="col-lg">
                    <h1 class="h5 fw-700">{{ $product->getTranslation('name') }}</h1>
                    <div class="d-flex flex-wrap">
                        <div class="border border-dotted rounded py-2 px-3 mr-3 ml-0">
                            <div class="h3 mb-0 fw-700">{{ $product->num_of_sale }}</div>
                            <div class="opacity-60 fs-12">{{ translate('Times sold') }}</div>
                        </div>
                        <div class="border border-dotted rounded py-2 px-3 mr-3 ml-0">
                            <div class="h3 mb-0 fw-700">{{ format_price($product->orderDetails()->sum('price')) }}</div>
                            <div class="opacity-60 fs-12">{{ translate('Amount sold') }}</div>
                        </div>
                        @if ($product->discount > 0)
                            <div class="border border-dotted rounded py-2 px-3 mr-3 ml-0 bg-danger text-white">
                                @if ($product->discount_type == 'flat')
                                    <span class="h3 mb-0 fw-700">{{ format_price($product->discount) }}</span>
                                @else
                                    <span class="h3 mb-0 fw-700">{{ $product->discount }}%</span>
                                @endif
                                {{ translate('Off') }}
                                <div class="opacity-60 fs-12">
                                    {{ date('Y/m/d H:i:s', $product->discount_start_date) }} -
                                    {{ date('Y/m/d H:i:s', $product->discount_end_date) }}
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-auto w-lg-320px">
            <div class="card">
                <div class="card-body">
                    <div class="mb-3 d-flex justify-content-between">
                        <span class="mr-2 ml-0">{{ translate('Status') }}:</span>
                        @if ($product->published)
                            <span class="badge badge-inline badge-success">{{ translate('Published') }}</span>
                        @else
                            <span class="badge badge-inline badge-secondary">{{ translate('Draft') }}</span>
                        @endif
                    </div>
                    <div class="mb-3 d-flex justify-content-between">
                        <span class="mr-2 ml-0">{{ translate('Minimum Purchase Qty ') }}:</span>
                        <span>{{ $product->min_qty }}</span>
                    </div>
                    <div class="mb-3 d-flex justify-content-between">
                        <span class="mr-2 ml-0">{{ translate('Maximum Purchase Qty ') }}:</span>
                        <span>{{ $product->max_qty }}</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg">
            <div class="card">
                <div class="card-header mb-0 h6">{{ translate('Product price, stock') }}</div>
                <div class="card-body">
                    <table class="table table-bordered table-responsive-xl">
                        <thead>
                            <tr>
                                <td class="">
                                    <label for="" class="control-label">{{ translate('Price') }}</label>
                                </td>
                                <td class="">
                                    <label for="" class="control-label">{{ translate('Stock') }}</label>
                                </td>
                                <td class="">
                                    <label for="" class="control-label">{{ translate('SKU') }}</label>
                                </td>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="variant">
                                <td>
                                    <div>{{ format_price($product->lowest_price) }}</div>
                                </td>
                                <td>
                                    <div>
                                        @if ($product->stock == '1')
                                            {{ translate('In stock') }}
                                        @else
                                            {{ translate('Out of stock') }}
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        {{ $product->sku }}
                                    </div>
                                </td>

                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{ translate('Product Description') }}</h5>
                </div>
                <div class="card-body">
                    {!! $product->getTranslation('description') !!}
                </div>
            </div>

        </div>
    </div>
@endsection
