@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar text-left mt-2 mb-3">
        <div class="row align-items-center">
            <div class="col-md-12">
                <h1 class="h3">{{ translate('All Barangays') }}</h1>
            </div>
            <div class="col-md-8 text-md-right">
                <a href="{{ route('barangays.create') }}" class="btn btn-primary">
                    <span>{{ translate('Add Barangay') }}</span>
                </a>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-7">
            <div class="card">
                <form class="" id="sort_barangays" action="" method="GET">
                    <div class="card-header row gutters-5">
                        <div class="col text-center text-md-left">
                            <h5 class="mb-md-0 h6">{{ translate('Barangays') }}</h5>
                        </div>
                        <div class="col-md-4">
                            <input type="text" class="form-control" id="sort_barangay" name="sort_barangay"
                                @isset($sort_barangay) value="{{ $sort_barangay }}" @endisset
                                placeholder="{{ translate('Type barangay name & Enter') }}">
                        </div>
                        <div class="col-md-4">
                            <select class="form-control aiz-selectpicker" data-live-search="true" id="sort_city"
                                name="sort_city">
                                <option value="">{{ translate('Select Barangay') }}</option>
                                @foreach ($barangays as $barangay)
                                    <option value="{{ $barangay->id }}" @if ($sort_barangay == $barangay->id) selected @endif
                                        {{ $sort_barangay }}>
                                        {{ $barangay->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-primary" type="submit">{{ translate('Filter') }}</button>
                        </div>
                    </div>
                </form>
                <div class="card-body">
                    <table class="table aiz-table mb-0">
                        <thead>
                            <tr>
                                <th data-breakpoints="lg">#</th>
                                <th>{{ translate('Name') }}</th>
                                <th>{{ translate('City') }}</th>
                                <th>{{ translate('Show/Hide') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($barangays as $key => $barangay)
                                <tr>
                                    <td>{{ $key + 1 + ($barangays->currentPage() - 1) * $barangays->perPage() }}</td>
                                    <td>{{ $barangay->name }}</td>
                                    <td>{{ $barangay->city->name }}</td>
                                    <td>
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input onchange="update_status(this)" value="{{ $barangay->id }}"
                                                type="checkbox" <?php if ($barangay->status == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <span class="slider round"></span>
                                        </label>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="aiz-pagination">
                        {{ $barangays->appends(request()->input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('modal')
    @include('backend.inc.delete_modal')
@endsection


@section('script')
    <script type="text/javascript">
        function sort_barangays(el) {
            $('#sort_barangays').submit();
        }

        function update_status(el) {
            if (el.checked) {
                var status = 1;
            } else {
                var status = 0;
            }
            $.post('{{ route('barangays.status') }}', {
                _token: '{{ csrf_token() }}',
                id: el.value,
                status: status
            }, function(data) {
                if (data == 1) {
                    AIZ.plugins.notify('success', '{{ translate('Country status updated successfully') }}');
                } else {
                    AIZ.plugins.notify('danger', '{{ translate('Something went wrong') }}');
                }
            });
        }
    </script>
@endsection
