@extends('backend.layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h1 class="mb-0 h6">{{ translate('General Settings') }}</h1>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('settings.update') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row">
                            <label class="col-sm-3 col-from-label">{{ translate('System Name') }}</label>
                            <div class="col-sm-9">
                                <input type="hidden" name="types[]" value="site_name">
                                <input type="text" name="site_name" class="form-control"
                                    value="{{ get_setting('site_name') }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-from-label">{{ translate('System Logo - White') }}</label>
                            <div class="col-sm-9">
                                <div class="input-group" data-toggle="aizuploader" data-type="image">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Choose Files') }}</div>
                                    <input type="hidden" name="types[]" value="system_logo_white">
                                    <input type="hidden" name="system_logo_white"
                                        value="{{ get_setting('system_logo_white') }}" class="selected-files">
                                </div>
                                <div class="file-preview box sm"></div>
                                <small>{{ translate('Will be used in admin panel side menu') }}</small>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-from-label">{{ translate('System Logo - Black') }}</label>
                            <div class="col-sm-9">
                                <div class="input-group" data-toggle="aizuploader" data-type="image">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Choose Files') }}</div>
                                    <input type="hidden" name="types[]" value="system_logo_black">
                                    <input type="hidden" name="system_logo_black"
                                        value="{{ get_setting('system_logo_black') }}" class="selected-files">
                                </div>
                                <div class="file-preview box sm"></div>
                                <small>{{ translate('Will be used in admin panel topbar in mobile + Admin login page') }}</small>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-from-label">{{ translate('Admin login page background') }}</label>
                            <div class="col-sm-9">
                                <div class="input-group" data-toggle="aizuploader" data-type="image">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Choose Files') }}</div>
                                    <input type="hidden" name="types[]" value="admin_login_background">
                                    <input type="hidden" name="admin_login_background"
                                        value="{{ get_setting('admin_login_background') }}" class="selected-files">
                                </div>
                                <div class="file-preview box sm"></div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-from-label">{{ translate('Bank Payout fee (PHP)') }}</label>
                            <div class="col-sm-9">
                                <input type="hidden" name="types[]" value="payout_fee_amount">
                                <input type="number" class="form-control" name="payout_fee_amount" min="0"
                                    step="0.01" value="{{ get_setting('payout_fee_amount') ?? 25 }}" required>
                                <small
                                    class="text-muted">{{ translate('Applied per successful payout transaction.') }}</small>
                            </div>
                        </div>

                        <div class="text-right">
                            <button type="submit" class="btn btn-primary">{{ translate('Update') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    @if (addon_is_activated('multi_vendor'))
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card">
                    <div class="card-header">
                        <h1 class="mb-0 h6">{{ translate('Seller Minimum Withdrawal Amount') }}</h1>
                    </div>
                    <div class="card-body">
                        <form class="form-horizontal" action="{{ route('settings.update') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="form-group row">
                                <label class="col-sm-3 col-from-label">{{ translate('Minimum withdrawal amount') }}</label>
                                <div class="col-sm-9">
                                    <input type="hidden" name="types[]" value="min_withdrawal_amount">
                                    <input type="number" class="form-control" name="min_withdrawal_amount"
                                        min="0" step="0.01" value="{{ get_setting('min_withdrawal_amount') }}"
                                        required>
                                </div>
                            </div>
                            <div class="text-right">
                                <button type="submit" class="btn btn-primary">{{ translate('Update') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
    {{-- <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h1 class="mb-0 h6">{{ translate('Shop Settings') }}</h1>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('shop_settings.update') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row">
                            <label class="col-sm-3 col-from-label">{{ translate('Minimum order amount') }}</label>
                            <div class="col-sm-9">
                                <input type="number" class="form-control" name="min_order" min="0"
                                    step="0.01" value="{{ auth()->user()->shop->min_order }}" required>
                                <small
                                    class="text-muted">{{ translate('Customer need to purchase minimum this amount of admin shop products to place an order.') }}</small>
                            </div>
                        </div>
                        <div class="text-right">
                            <button type="submit" class="btn btn-primary">{{ translate('Update') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> --}}

    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h1 class="mb-0 h6">{{ translate('Cache Settings') }}</h1>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('settings.update') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row">
                            <label class="col-sm-3 col-from-label">{{ translate('Current cache version') }}</label>
                            <div class="col-sm-9">
                                <div class="form-control bg-soft-secondary">
                                    {{ get_setting('force_cache_clear_version') }}</div>
                                <input type="hidden" name="types[]" value="force_cache_clear_version">
                                <input type="hidden" name="force_cache_clear_version" class="form-control"
                                    value="{{ strtolower(Str::random(30)) }}">
                            </div>
                        </div>
                        <div class="text-right">
                            <button type="submit" class="btn btn-primary">{{ translate('Force Clear Cache') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h1 class="mb-0 h6">{{ translate('Features Activation') }}</h1>
                </div>
                <div class="card-body">
                    <div class="form-group row">
                        <label class="col-sm-6 col-from-label">{{ translate('Forcefully HTTPS redirection') }}</label>
                        <div class="col-sm-6">
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" onchange="updateSettings(this, 'FORCE_HTTPS')"
                                    @if (env('FORCE_HTTPS') == 'On') checked @endif>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-6 col-from-label">{{ translate('Maintenance Mode') }}</label>
                        <div class="col-sm-6">
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" onchange="updateSettings(this, 'maintenance_mode')"
                                    <?php if (get_setting('maintenance_mode') == 1) {
                                        echo 'checked';
                                    } ?>>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                    {{-- <div class="form-group row">
                        <div class="col-sm-6">
                            <label class="col-from-label">{{ translate('Email Verification') }}</label>
                            <i>
                                <code>({{ translate('You need to configure SMTP correctly to enable this feature.') }}</code>
                                <a href="{{ route('smtp_settings.index') }}">{{ translate('Configure Now') }}</a>)
                            </i>
                        </div>
                        <div class="col-sm-6">
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" onchange="updateSettings(this, 'email_verification')"
                                    @if (get_setting('email_verification') == 1) checked @endif>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div> --}}
                    {{-- <div class="form-group row">
                        <label class="col-sm-6 col-from-label">{{ translate('Wallet System Activation') }}</label>
                        <div class="col-sm-6">
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" onchange="updateSettings(this, 'wallet_system')"
                                    @if (get_setting('wallet_system') == 1) checked @endif>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div> --}}

                    {{-- <div class="form-group row">
                        <label class="col-sm-6 col-from-label">{{ translate('Club Point Activation') }}</label>
                        <div class="col-sm-6">
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" onchange="updateSettings(this, 'club_point')"
                                    @if (get_setting('club_point') == 1) checked @endif>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div> --}}

                    {{-- <div class="form-group row">
                        <label class="col-sm-6 col-from-label">{{ translate('Product Comparison') }}</label>
                        <div class="col-sm-6">
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" onchange="updateSettings(this, 'product_comparison')"
                                    <?php if (get_setting('product_comparison') == 1) {
                                        echo 'checked';
                                    } ?>>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div> --}}
                    {{-- <div class="form-group row">
                        <label class="col-sm-6 col-from-label">{{ translate('Affiliate System') }}</label>
                        <div class="col-sm-6">
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" onchange="updateSettings(this, 'affiliate_system')"
                                    <?php if (get_setting('affiliate_system') == 1) {
                                        echo 'checked';
                                    } ?>>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div> --}}

                    {{-- @if (addon_is_activated('multi_vendor'))
                        <div class="form-group row">
                            <label
                                class="col-sm-6 col-from-label">{{ translate('Admin Approval On Seller Product') }}</label>
                            <div class="col-sm-6">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input type="checkbox" onchange="updateSettings(this, 'product_approve_by_admin')"
                                        <?php if (get_setting('product_approve_by_admin') == 1) {
                                            echo 'checked';
                                        } ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label
                                class="col-sm-6 col-from-label">{{ translate('Seller Product Manage By Admin') }}</label>
                            <div class="col-sm-6">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input type="checkbox" onchange="updateSettings(this, 'product_manage_by_admin')"
                                        <?php if (get_setting('product_manage_by_admin') == 1) {
                                            echo 'checked';
                                        } ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-6 col-from-label">{{ translate('Seller Order Manage By Admin') }}</label>
                            <div class="col-sm-6">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input type="checkbox" onchange="updateSettings(this, 'order_manage_by_admin')"
                                        <?php if (get_setting('order_manage_by_admin') == 1) {
                                            echo 'checked';
                                        } ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    @endif --}}

                    {{-- @if ((float) get_setting('current_version') > 1.3 && addon_is_activated('multi_vendor'))
                        <div class="form-group row">
                            <label
                                class="col-sm-6 col-from-label">{{ translate('Conversation System Activation') }}</label>
                            <div class="col-sm-6">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input type="checkbox" onchange="updateSettings(this, 'conversation_system')"
                                        @if (get_setting('conversation_system') == 1) checked @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    @endif --}}

                    {{-- @if ((float) get_setting('current_version') > 1.6)
                        <div class="form-group row">
                            <label class="col-sm-6 col-from-label">{{ translate('Offline Payment') }}</label>
                            <div class="col-sm-6">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input type="checkbox" onchange="updateSettings(this, 'offline_payment')"
                                        @if (get_setting('offline_payment') == 1) checked @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    @endif --}}


                    <div class="form-group row">
                        <label class="col-sm-6 col-from-label">{{ translate('Sticky Header') }}</label>
                        <div class="col-sm-6">
                            <label class="aiz-switch aiz-switch-success mb-0">
                                <input type="checkbox" onchange="updateSettings(this, 'sticky_header')"
                                    @if (get_setting('sticky_header') == 1) checked @endif>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h1 class="mb-0 h6">{{ translate('Chat Settings') }}</h1>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('settings.update') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Chat logo') }}</label>
                            <div class="col-md-8">
                                <div class=" input-group " data-toggle="aizuploader" data-type="image">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">
                                            {{ translate('Browse') }}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                                    <input type="hidden" name="types[]" value="customer_chat_logo">
                                    <input type="hidden" name="customer_chat_logo" class="selected-files"
                                        value="{{ get_setting('customer_chat_logo') }}">
                                </div>
                                <div class="file-preview"></div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Chat name') }}</label>
                            <div class="col-md-8">
                                <div class="form-group">
                                    <input type="hidden" name="types[]" value="customer_chat_name">
                                    <input type="text" class="form-control" placeholder="" name="customer_chat_name"
                                        value="{{ get_setting('customer_chat_name') }}">
                                </div>
                            </div>
                        </div>
                        <div class="text-right">
                            <button type="submit" class="btn btn-primary">{{ translate('Update') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h1 class="mb-0 h6">{{ translate('Invoice Settings') }}</h1>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('settings.update') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Invoice logo') }}</label>
                            <div class="col-md-8">
                                <div class=" input-group " data-toggle="aizuploader" data-type="image">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">
                                            {{ translate('Browse') }}</div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                                    <input type="hidden" name="types[]" value="invoice_logo">
                                    <input type="hidden" name="invoice_logo" class="selected-files"
                                        value="{{ get_setting('invoice_logo') }}">
                                </div>
                                <div class="file-preview"></div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Address') }}</label>
                            <div class="col-md-8">
                                <input type="hidden" name="types[]" value="invoice_address">
                                <input type="text" class="form-control" placeholder="{{ translate('Address') }}"
                                    name="invoice_address" value="{{ get_setting('invoice_address') }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Email') }}</label>
                            <div class="col-md-8">
                                <input type="hidden" name="types[]" value="invoice_email">
                                <input type="text" class="form-control" placeholder="{{ translate('Email') }}"
                                    name="invoice_email" value="{{ get_setting('invoice_email') }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Phone') }}</label>
                            <div class="col-md-8">
                                <input type="hidden" name="types[]" value="invoice_phone">
                                <input type="text" class="form-control" placeholder="{{ translate('Phone') }}"
                                    name="invoice_phone" value="{{ get_setting('invoice_phone') }}">
                            </div>
                        </div>
                        <div class="text-right">
                            <button type="submit" class="btn btn-primary">{{ translate('Update') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{ translate('SMTP Settings') }}</h5>
                </div>
                <div class="card-body">
                    <form class="form-horizontal" action="{{ route('env_key_update.update') }}" method="POST">
                        @csrf
                        <div class="form-group row">
                            <input type="hidden" name="types[]" value="MAIL_DRIVER">
                            <label class="col-md-3 col-form-label">{{ translate('Type') }}</label>
                            <div class="col-md-7">
                                <select class="form-control aiz-selectpicker mb-2 mb-md-0" name="MAIL_DRIVER"
                                    onchange="checkMailDriver()">
                                    <option value="sendmail" @if (env('MAIL_DRIVER') == 'sendmail') selected @endif>
                                        {{ translate('Sendmail') }}</option>
                                    <option value="smtp" @if (env('MAIL_DRIVER') == 'smtp') selected @endif>
                                        {{ translate('SMTP') }}</option>
                                    <option value="mailgun" @if (env('MAIL_DRIVER') == 'mailgun') selected @endif>
                                        {{ translate('Mailgun') }}</option>
                                </select>
                            </div>
                        </div>
                        <div id="smtp">
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAIL_HOST">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAIL HOST') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAIL_HOST"
                                        value="{{ env('MAIL_HOST') }}" placeholder="{{ translate('MAIL HOST') }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAIL_PORT">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAIL PORT') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAIL_PORT"
                                        value="{{ env('MAIL_PORT') }}" placeholder="{{ translate('MAIL PORT') }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAIL_USERNAME">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAIL USERNAME') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAIL_USERNAME"
                                        value="{{ env('MAIL_USERNAME') }}"
                                        placeholder="{{ translate('MAIL USERNAME') }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAIL_PASSWORD">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAIL PASSWORD') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAIL_PASSWORD"
                                        value="{{ env('MAIL_PASSWORD') }}"
                                        placeholder="{{ translate('MAIL PASSWORD') }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAIL_ENCRYPTION">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAIL ENCRYPTION') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAIL_ENCRYPTION"
                                        value="{{ env('MAIL_ENCRYPTION') }}"
                                        placeholder="{{ translate('MAIL ENCRYPTION') }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAIL_FROM_ADDRESS">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAIL FROM ADDRESS') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAIL_FROM_ADDRESS"
                                        value="{{ env('MAIL_FROM_ADDRESS') }}"
                                        placeholder="{{ translate('MAIL FROM ADDRESS') }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAIL_FROM_NAME">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAIL FROM NAME') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAIL_FROM_NAME"
                                        value="{{ env('MAIL_FROM_NAME') }}"
                                        placeholder="{{ translate('MAIL FROM NAME') }}">
                                </div>
                            </div>
                        </div>
                        <div id="mailgun">
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAILGUN_DOMAIN">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAILGUN DOMAIN') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAILGUN_DOMAIN"
                                        value="{{ env('MAILGUN_DOMAIN') }}"
                                        placeholder="{{ translate('MAILGUN DOMAIN') }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <input type="hidden" name="types[]" value="MAILGUN_SECRET">
                                <div class="col-md-3">
                                    <label class="col-from-label">{{ translate('MAILGUN SECRET') }}</label>
                                </div>
                                <div class="col-md-7">
                                    <input type="text" class="form-control" name="MAILGUN_SECRET"
                                        value="{{ env('MAILGUN_SECRET') }}"
                                        placeholder="{{ translate('MAILGUN SECRET') }}">
                                </div>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit" class="btn btn-sm btn-primary">{{ translate('Save') }}</button>
                        </div>
                    </form>

                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{ translate('Test SMTP configuration') }}</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('test.smtp') }}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col">
                                <input type="email" class="form-control" name="email"
                                    value="{{ auth()->user()->email }}"
                                    placeholder="{{ translate('Enter your email address') }}">
                            </div>
                            <div class="col-auto">
                                <button type="submit"
                                    class="btn btn-primary">{{ translate('Send test email') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endsection

    @section('script')
        <script type="text/javascript">
            function updateSettings(el, type) {
                if ($(el).is(':checked')) {
                    var value = 1;
                } else {
                    var value = 0;
                }
                $.post('{{ route('settings.update.activation') }}', {
                    _token: '{{ csrf_token() }}',
                    type: type,
                    value: value
                }, function(data) {
                    if (data == '1') {
                        AIZ.plugins.notify('success', '{{ translate('Settings updated successfully') }}');
                    } else {
                        AIZ.plugins.notify('danger', '{{ translate('Something went wrong') }}');
                    }
                });
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function() {
                checkMailDriver();
            });

            function checkMailDriver() {
                if ($('select[name=MAIL_DRIVER]').val() == 'mailgun') {
                    $('#mailgun').show();
                    $('#smtp').hide();
                } else {
                    $('#mailgun').hide();
                    $('#smtp').show();
                }
            }
        </script>
    @endsection
