@extends('backend.layouts.app')

@section('content')

    <div class="col-lg-8 mx-auto">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{ translate('Zone Information') }}</h5>
            </div>
            <div class="card-body">
                <form class="form-horizontal" action="{{ route('zones.update', $zone) }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="_method" value="PATCH">
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">{{ translate('Name') }}</label>
                        <div class="col-md-9">
                            <input type="text" placeholder="{{ translate('Name') }}" id="name" name="name"value="{{ $zone->name }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">{{ translate('Cities') }}</label>
                        <div class="col-md-9">
                            <select class="select2 form-control aiz-selectpicker" name="cities[]" data-title="{{ translate('Select cities') }}" data-live-search="true" data-max-options="100"  data-selected-text-format="count" multiple required>
                                <option value="0">{{ translate('No City') }}</option>
                                @foreach ($cities as $city)
                                    <option value="{{ $city->id }}" @if ($zone->id == $city->zone_id) selected @endif>{{ $city->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">
                            {{ translate('Standard Delivery Cost') }}
                        </label>
                        <div class="col-md-9">
                            <input type="number" step="0.01" name="standard_delivery_cost" class="form-control" id="standard_delivery_cost" value="{{ $zone->standard_delivery_cost }}" placeholder="{{ translate('Standard Delivery Cost') }}" required>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-md-3 col-form-label">
                            {{ translate('Express Delivery Cost') }}
                        </label>
                        <div class="col-md-9">
                            <input type="number" step="0.01" name="express_delivery_cost" class="form-control" id="express_delivery_cost" value="{{ $zone->express_delivery_cost }}" placeholder="{{ translate('Express Delivery Cost') }}" required>
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">{{ translate('Save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection
