@extends('backend.layouts.page')

@section('content')
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <div class="mt-4">
                <div class="align-items-center gutters-5 row">
                    <div class="col">
                        <div class="overflow-hidden">
                            <div class="card-body align-items-center justify-content-center">
                                <div class="form-group row">
                                    <div class="card-body">
                                        <form class="form form-horizontal mar-top" method="POST" role="form"
                                            action="{{ route('signup') }}">
                                            @csrf
                                            @if ($errors->any())
                                                <div class="alert alert-danger">
                                                    <ul class="mb-0">
                                                        @foreach ($errors->all() as $error)
                                                            <li>{{ $error }}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endif

                                            <div class="row gutters-5">
                                                <div class="col-lg">
                                                    <div class="card">
                                                        <div style="justify-content: center;" class="card-header">
                                                            <h5 class="mb-0 h6">{{ translate('Membership Registration') }}
                                                            </h5>
                                                        </div>

                                                        <input id="sellerid" type="hidden" class="form-control"
                                                            name="sellerid" value="{{ request('sellerid') }}" required>

                                                        <div class="card-body">
                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('First Name') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8">
                                                                    <input id="first_name" type="text"
                                                                        class="form-control @error('first_name') is-invalid @enderror"
                                                                        name="first_name"
                                                                        placeholder="{{ translate('First Name') }}"
                                                                        value="{{ old('first_name') }}" required>
                                                                    @error('first_name')
                                                                        <span class="invalid-feedback"
                                                                            role="alert"><strong>{{ $message }}</strong></span>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Last Name') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8">
                                                                    <input id="last_name" type="text"
                                                                        class="form-control @error('last_name') is-invalid @enderror"
                                                                        name="last_name"
                                                                        placeholder="{{ translate('Last Name') }}"
                                                                        value="{{ old('last_name') }}" required>
                                                                    @error('last_name')
                                                                        <span class="invalid-feedback"
                                                                            role="alert"><strong>{{ $message }}</strong></span>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Email') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8">
                                                                    <input id="email" type="email"
                                                                        class="form-control @error('email') is-invalid @enderror"
                                                                        name="email"
                                                                        placeholder="{{ translate('Email') }}"
                                                                        value="{{ old('email') }}" required>
                                                                    <small class="form-text text-muted">Accepted Email:
                                                                        Gmail, Microsoft, and Yahoo Only</small>
                                                                    @error('email')
                                                                        <span class="invalid-feedback"
                                                                            role="alert"><strong>{{ $message }}</strong></span>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Phone No.') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8">
                                                                    <input id="phone" type="tel"
                                                                        class="form-control @error('phone') is-invalid @enderror"
                                                                        name="phone"
                                                                        placeholder="{{ translate('Phone No.') }}"
                                                                        pattern="[0-9]{11}"
                                                                        title="Please enter a valid 11-digit phone number"
                                                                        value="{{ old('phone') }}" required>
                                                                    @error('phone')
                                                                        <span class="invalid-feedback"
                                                                            role="alert"><strong>{{ $message }}</strong></span>
                                                                    @enderror
                                                                    <small class="form-text text-muted">Format:
                                                                        09053456789</small>
                                                                </div>
                                                            </div>

                                                            {{-- Country --}}
                                                            @if ($geographicLevel == 5)
                                                                <div class="form-group row" id="country_group">
                                                                    <label class="col-md-3 col-from-label">Country</label>
                                                                    <div class="col-md-8">
                                                                        <select id="country_select" name="selected_country"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select Country') }}</option>
                                                                        </select>
                                                                        @error('selected_country')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            {{-- Region --}}
                                                            @if ($geographicLevel == 4)
                                                                <div class="form-group row" id="region_group">
                                                                    <label class="col-md-3 col-from-label">Region</label>
                                                                    <div class="col-md-8">
                                                                        <select id="region_select" name="selected_region"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select Region') }}</option>
                                                                            @foreach ($regions as $region)
                                                                                <option value="{{ $region->id }}">
                                                                                    {{ $region->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @error('selected_region')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            {{-- Province (Level 1..3) --}}
                                                            @if ($geographicLevel >= 1 && $geographicLevel <= 3)
                                                                <div class="form-group row" id="state_group">
                                                                    <label class="col-md-3 col-from-label">Province</label>
                                                                    <div class="col-md-8">
                                                                        <select id="state_select" name="selected_state"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select Province') }}</option>
                                                                            @foreach ($states as $state)
                                                                                <option value="{{ $state->id }}">
                                                                                    {{ $state->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @error('selected_state')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            {{-- City (Level 1..2) --}}
                                                            @if ($geographicLevel >= 1 && $geographicLevel <= 2)
                                                                <div class="form-group row" id="city_group">
                                                                    <label class="col-md-3 col-from-label">City</label>
                                                                    <div class="col-md-8">
                                                                        <select id="city_select" name="selected_city"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select City') }}</option>
                                                                            @foreach ($cities as $city)
                                                                                <option value="{{ $city->id }}">
                                                                                    {{ $city->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @error('selected_city')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            {{-- Barangay (Level 1) --}}
                                                            @if ($geographicLevel == 1)
                                                                <div class="form-group row" id="barangay_group">
                                                                    <label class="col-md-3 col-from-label">Barangay</label>
                                                                    <div class="col-md-8">
                                                                        <select id="barangay_select"
                                                                            name="selected_barangay"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select Barangay') }}</option>
                                                                            @foreach ($barangays as $barangay)
                                                                                <option value="{{ $barangay->id }}">
                                                                                    {{ $barangay->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @error('selected_barangay')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            {{-- Membership --}}
                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Membership Package') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8">
                                                                    <select id="mempckge_select"
                                                                        class="form-control aiz-selectpicker"
                                                                        name="membership" required>
                                                                        <option value="" disabled
                                                                            {{ old('membership', request('mempckge')) ? '' : 'selected' }}>
                                                                            {{ translate('Select Package') }}
                                                                        </option>
                                                                        @foreach ($packages as $package)
                                                                            <option value="{{ $package->id }}"
                                                                                {{ (string) old('membership', request('mempckge')) === (string) $package->id ? 'selected' : '' }}>
                                                                                {{ $package->name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                    @error('membership')
                                                                        <small
                                                                            class="text-danger d-block mt-1">{{ $message }}</small>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Password') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8 position-relative">
                                                                    <div class="input-group">
                                                                        <input id="password" type="password"
                                                                            class="form-control @error('password') is-invalid @enderror"
                                                                            name="password" value="{{ old('password') }}"
                                                                            required
                                                                            placeholder="{{ translate('Password') }}">
                                                                        <div class="input-group-append">
                                                                            <a type="button"
                                                                                class="btn btn-outline-secondary toggle-password"
                                                                                onclick="togglePassword('password', this)">
                                                                                <i class="las la-eye"></i>
                                                                            </a>
                                                                        </div>
                                                                        @error('password')
                                                                            <span class="invalid-feedback"
                                                                                role="alert"><strong>{{ $message }}</strong></span>
                                                                        @enderror
                                                                    </div>
                                                                    <small class="form-text text-muted">Min 6 and max 20
                                                                        characters</small>
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Confirm Password') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8 position-relative">
                                                                    <input id="confirm_password" type="password"
                                                                        class="form-control @error('password_confirmation') is-invalid @enderror"
                                                                        name="password_confirmation" required
                                                                        placeholder="{{ translate('Confirm Password') }}">
                                                                    @error('password_confirmation')
                                                                        <span class="invalid-feedback"
                                                                            role="alert"><strong>{{ $message }}</strong></span>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                        </div> {{-- card-body --}}
                                                    </div> {{-- card --}}
                                                </div> {{-- col-lg --}}
                                            </div> {{-- row --}}

                                            <div class="mar-all text-center mb-3">
                                                <button type="submit" class="btn btn-primary"
                                                    id="register-seller">{{ translate('Register') }}</button>
                                            </div>

                                        </form>
                                    </div> {{-- inner card-body --}}
                                </div> {{-- form-group row --}}
                            </div> {{-- outer card-body --}}
                        </div> {{-- overflow-hidden --}}
                    </div> {{-- col --}}
                </div> {{-- row --}}
            </div> {{-- mt-4 --}}
        </div> {{-- col --}}
    </div> {{-- row --}}
@endsection

@section('script')
    <script>
        var jq = jQuery.noConflict();
    </script>
    <script>
        window.togglePassword = function(inputId, btn) {
            var el = document.getElementById(inputId);
            if (!el) return;
            el.type = (el.type === 'password') ? 'text' : 'password';

            if (btn) {
                var icon = btn.querySelector('i');
                if (icon) {
                    icon.classList.toggle('la-eye');
                    icon.classList.toggle('la-eye-slash');
                }
            }
        };
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var baseUrl = '{{ URL::to('/') }}';
            var geographicLevel = {{ (int) $geographicLevel }};
            var mempckgeSelect = document.getElementById('mempckge_select');
            var countrySelect = document.getElementById('country_select');

            var stateSelect = document.getElementById('state_select');
            var citySelect = document.getElementById('city_select');
            var barangaySelect = document.getElementById('barangay_select');

            function refreshPickers() {
                if (jq && jq('.aiz-selectpicker').length) jq('.aiz-selectpicker').selectpicker('refresh');
            }

            function clearSelect(el, placeholder) {
                if (!el) return;
                el.innerHTML = '<option value="" selected disabled>' + placeholder + '</option>';
                refreshPickers();
            }

            function loadCountries() {
                if (!countrySelect || !mempckgeSelect) return;
                var mempckge = mempckgeSelect.value || '{{ request('mempckge') }}';
                clearSelect(countrySelect, "{{ translate('Select Country') }}");

                fetch(`${baseUrl}/api/get-countries?mempckge=${mempckge}`)
                    .then(r => r.json())
                    .then(data => {
                        (data.countries || []).forEach(function(co) {
                            var opt = document.createElement("option");
                            opt.value = co.id;
                            opt.textContent = co.name;
                            countrySelect.appendChild(opt);
                        });
                        var oldCountry = "{{ old('selected_country') }}";
                        if (oldCountry) {
                            countrySelect.value = oldCountry;
                        }
                        refreshPickers();
                    })
                    .catch(err => console.error("Error fetching countries:", err));
            }

            function loadCities(stateId) {
                if (!citySelect || !mempckgeSelect || !stateId) return;
                var mempckge = mempckgeSelect.value;

                clearSelect(citySelect, "{{ translate('Select City') }}");
                if (barangaySelect) clearSelect(barangaySelect, "{{ translate('Select Barangay') }}");

                fetch(`${baseUrl}/api/get-cities/${stateId}?mempckge=${mempckge}`)
                    .then(function(r) {
                        return r.json();
                    })
                    .then(function(data) {
                        (data.cities || []).forEach(function(city) {
                            var opt = document.createElement("option");
                            opt.value = city.id;
                            opt.textContent = city.name;
                            citySelect.appendChild(opt);
                        });
                        refreshPickers();
                    })
                    .catch(function(err) {
                        console.error("Error fetching cities:", err);
                    });
            }

            function loadBarangays(cityId) {
                if (!barangaySelect || !mempckgeSelect || !cityId) return;
                var mempckge = mempckgeSelect.value;

                clearSelect(barangaySelect, "{{ translate('Select Barangay') }}");

                fetch(`${baseUrl}/api/get-barangays/${cityId}?mempckge=${mempckge}`)
                    .then(function(r) {
                        return r.json();
                    })
                    .then(function(data) {
                        (data.barangays || []).forEach(function(b) {
                            var opt = document.createElement("option");
                            opt.value = b.id;
                            opt.textContent = b.name;
                            barangaySelect.appendChild(opt);
                        });
                        refreshPickers();
                    })
                    .catch(function(err) {
                        console.error("Error fetching barangays:", err);
                    });
            }

            // Province → City for Level 1 and Level 2
            if (stateSelect && geographicLevel >= 1 && geographicLevel <= 2) {
                stateSelect.addEventListener('change', function() {
                    loadCities(this.value);
                });
            }

            // City → Barangay (harmless no-op at Level 2 where barangaySelect is absent)
            if (citySelect) {
                citySelect.addEventListener('change', function() {
                    loadBarangays(this.value);
                });
            }

            // Rehydrate old selections
            var oldState = "{{ old('selected_state') }}";
            var oldCity = "{{ old('selected_city') }}";
            var oldBrgy = "{{ old('selected_barangay') }}";

            if ((geographicLevel === 1 || geographicLevel === 2) && oldState && stateSelect) {
                stateSelect.value = oldState;
                refreshPickers();
                loadCities(oldState);

                setTimeout(function() {
                    if (oldCity && citySelect) {
                        citySelect.value = oldCity;
                        refreshPickers();

                        if (geographicLevel === 1) {
                            loadBarangays(oldCity);
                            setTimeout(function() {
                                if (oldBrgy && barangaySelect) {
                                    barangaySelect.value = oldBrgy;
                                    refreshPickers();
                                }
                            }, 300);
                        }
                    }
                }, 300);
            } else {
                if (geographicLevel >= 1 && geographicLevel <= 2 && citySelect) {
                    clearSelect(citySelect, "{{ translate('Select City') }}");
                }
                if (geographicLevel === 1 && barangaySelect) {
                    clearSelect(barangaySelect, "{{ translate('Select Barangay') }}");
                }
            }

            // Package change → reload with mempckge (preserve sellerid)
            if (mempckgeSelect) {
                mempckgeSelect.addEventListener('change', function() {
                    var params = new URLSearchParams(window.location.search);
                    params.set('mempckge', this.value);

                    var sellerIdEl = document.getElementById('sellerid');
                    if (sellerIdEl && sellerIdEl.value) params.set('sellerid', sellerIdEl.value);

                    window.location = `${baseUrl}/membership-registration?${params.toString()}`;
                });
            }

            // Initial data fetches
            if (geographicLevel === 5) {
                loadCountries();
            }
        });
    </script>
@endsection
