@extends('backend.layouts.page')

@section('content')
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <div class="mt-4">
                <div class="card-body">
                    <div class="card" style="border:0;">
                        <div class="card-header" style="justify-content:center; border:0;">
                            <h5 class="mb-0 h6 text-center">
                                {{ translate('Registration successful. Thank you for registering!') }}
                            </h5>
                        </div>
                        <div class="card-body text-center">

                            @if (session('pending_approval_only'))
                                {{-- Geographic level = 0: no payment upload; wait for approval --}}
                                <p class="mb-4">
                                    {{ translate("Your account is currently pending approval. You'll receive an email once an admin approves your account. You’ll be able to log in after approval.") }}
                                </p>
                                <a href="/login" class="btn btn-soft-primary">
                                    {{ translate('Back to Login') }}
                                </a>
                            @elseif (session('needs_payment'))
                                {{-- Paid packages: prompt to log in and upload proof --}}
                                <p class="mb-4">
                                    {{ translate('Please log in to upload your payment proof so we can verify and activate your account.') }}
                                </p>
                                <a href="/login" class="btn btn-soft-primary">
                                    {{ translate('Login to Upload Payment Proof') }}
                                </a>
                            @else
                                {{-- Fallback (if someone loads this page directly) --}}
                                <p class="mb-4">
                                    {{ translate('If your package requires payment, please log in and upload your payment proof. Otherwise, your account is pending approval.') }}
                                </p>
                                <a href="/login" class="btn btn-soft-primary">
                                    {{ translate('Go to Login') }}
                                </a>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
