<?php

namespace App\Addons\Multivendor\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use App\Models\CommissionHistory;
use Illuminate\Http\Request;

class CommissionController extends Controller
{
  public function commission_history(Request $request)
  {
    $referrerUserId = auth()->id();        // was shop_id
    $date_range     = $request->date_range;

    // Filter by the CURRENT USER's id (not shop_id)
    $commission_history = \App\Models\CommissionHistory::where('user_id', $referrerUserId);

    if ($date_range) {
      [$start, $end] = array_pad(explode(' / ', $date_range), 2, null);
      if ($start && $end) {
        $commission_history
          ->whereDate('created_at', '>=', $start)
          ->whereDate('created_at', '<=', $end);
      }
    }

    $commission_history = $commission_history->latest()->paginate(10);

    // View doesn't actually use $shop_id, but keep a compatible var if you want
    return view(
      'addon:multivendor::seller.earnings.commission_history',
      compact('commission_history', 'referrerUserId', 'date_range')
    );
  }
}
