@extends('backend.layouts.app')

@section('content')
    <div class="col-lg-9 mx-auto">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0 h6">{{ translate('Create New Seller Package') }}</h5>
            </div>

            <form class="form-horizontal" action="{{ route('admin.seller_packages.store') }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="form-group row">
                        <label class="col-sm-2 col-from-label" for="name">{{ translate('Package Name') }}</label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{ translate('Name') }}" id="name" name="name"
                                class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-from-label" for="geographic_level">Geographic Level</label>
                        <div class="col-sm-10">
                            <select name="geographic_level" class="form-control" required>
                                <option value="" disabled selected>Select Geographic Level</option>
                                <option value="0">None</option>
                                <option value="1">Barangay</option>
                                <option value="2">City/Municipality</option>
                                <option value="3">Provincial</option>
                                <option value="4">Regional</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-from-label" for="amount">{{ translate('Amount') }}</label>
                        <div class="col-sm-10">
                            <input type="number" min="0" step="0.01" placeholder="{{ translate('Amount') }}"
                                id="amount" name="amount" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="commission">{{ translate('Sale Commission') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="commission" class="form-control"
                                required>
                        </div>
                        <div class="col-sm-5">
                            <select name="commission_type" class="form-control" required>
                                <option value="percent">%</option>
                                <option value="flat">₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label"
                            for="ref_commission">{{ translate('Referral Commission') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="ref_commission" class="form-control"
                                required>
                        </div>
                        <div class="col-sm-5">
                            <select name="ref_commission_type" class="form-control" required>
                                <option value="percent">%</option>
                                <option value="flat">₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label"
                            for="prod_discount">{{ translate('Product Discount') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="prod_discount" class="form-control"
                                required>
                        </div>
                        <div class="col-sm-5">
                            <select name="prod_discount_type" class="form-control" required>
                                <option value="percent">%</option>
                                <option value="flat">₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label"
                            for="ref_sale_commission">{{ translate('Referral Sale Commission') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="ref_sale_commission"
                                class="form-control" required>
                        </div>
                        <div class="col-sm-5">
                            <select name="ref_sale_commission_type" class="form-control" required>
                                <option value="percent">%</option>
                                <option value="flat">₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label"
                            for="area_sale_bonus">{{ translate('Area Sale Bonus') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="area_sale_bonus"
                                class="form-control" required>
                        </div>
                        <div class="col-sm-5">
                            <select name="area_sale_bonus_type" class="form-control" required>
                                <option value="percent">%</option>
                                <option value="flat">₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-2 col-form-label"
                            for="signinSrEmail">{{ translate('Package Logo') }}</label>
                        <div class="col-md-10">
                            <div class="input-group" data-toggle="aizuploader" data-type="image" data-multiple="false">
                                <div class="input-group-prepend">
                                    <div class="input-group-text bg-soft-secondary font-weight-medium">
                                        {{ translate('Browse') }}</div>
                                </div>
                                <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                                <input type="hidden" name="logo" class="selected-files">
                            </div>
                            <div class="file-preview box sm">
                            </div>
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-sm btn-primary">{{ translate('Save') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
