@extends('backend.layouts.app')

@section('content')
    <div class="card">
        <form id="sort_payments" action="" method="GET">
            <div class="card-header row gutters-5">
                <div class="col text-center text-md-left">
                    <h5 class="mb-0 h6">{{ translate('Payouts') }}</h5>
                </div>

                {{-- Filter by User --}}
                <div class="col-md-3 ml-auto">
                    <select class="form-control form-control-sm aiz-selectpicker mb-2 mb-md-0" name="user_id"
                        data-live-search="true" onchange="sort_payments()" data-selected="{{ $user_id ?? '' }}">
                        <option value="">{{ translate('Choose Seller') }}</option>
                        @foreach (\App\Models\User::where('user_type', '!=', 'admin')->orderBy('name')->get() as $u)
                            <option value="{{ $u->id }}">{{ $u->name }} (ID: {{ $u->id }})</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-2">
                    <div class="input-group">
                        <input type="text" class="form-control form-control-sm aiz-date-range" name="date_range"
                            @isset($date_range) value="{{ $date_range }}" @endisset
                            placeholder="{{ translate('Daterange') }}" autocomplete="off">
                    </div>
                </div>

                <div class="col-auto">
                    <button type="submit" class="btn btn-sm btn-primary">{{ translate('Filter') }}</button>
                </div>
            </div>
        </form>

        <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{ translate('Seller') }}</th>
                        <th>{{ translate('Amount') }}</th>
                        <th>{{ translate('Payment Method') }}</th>
                        <th>{{ translate('Date') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($payouts as $key => $payout)
                        <tr>
                            <td>{{ $key + 1 + ($payouts->currentPage() - 1) * $payouts->perPage() }}</td>
                            <td>{{ optional($payout->user)->name ?? translate('N/A') }}</td>
                            <td>{{ format_price($payout->paid_amount) }}</td>
                            <td>
                                {{ ucfirst(str_replace('_', ' ', $payout->payment_method)) }}
                                @if (!empty($payout->txn_code))
                                    ({{ translate('TRX ID') }} : {{ $payout->txn_code }})
                                @endif
                            </td>
                            <td>{{ date('d-m-Y', strtotime($payout->created_at)) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination">
                {{ $payouts->links() }}
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        function sort_payments() {
            document.getElementById('sort_payments').submit();
        }
    </script>
@endsection
