@extends('backend.layouts.app')

@section('content')
    <div class="card">
        <form id="sort_sellers" action="" method="GET">
            <div class="card-header row gutters-5">
                <div class="col">
                    <h5 class="mb-md-0 h6">{{ translate('Sellers') }}</h5>
                </div>

                <div class="col-md-3 ml-auto">
                    <select class="form-control aiz-selectpicker" name="approved_status" id="approved_status"
                        onchange="sort_sellers()" data-selected="{{ $approved }}">
                        <option value="">{{ translate('Filter by Approval') }}</option>
                        <option value="1">{{ translate('Approved') }}</option>
                        <option value="0">{{ translate('Non-Approved') }}</option>
                    </select>
                </div>

                <div class="col-md-3">
                    <div class="form-group mb-0">
                        <input type="text" class="form-control" id="search" name="search"
                            @isset($sort_search) value="{{ $sort_search }}" @endisset
                            placeholder="{{ translate('Type name, phone or email & Enter') }}">
                    </div>
                </div>
            </div>

            <div class="card-body">
                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            <th data-breakpoints="lg">#</th>
                            <th data-breakpoints="lg">{{ translate('Seller Info') }}</th>
                            <th data-breakpoints="lg">{{ translate('Account Type') }}</th>
                            <th data-breakpoints="lg">{{ translate('Current balance') }}</th>
                            <th data-breakpoints="lg">{{ translate('Seller Approval') }}</th>
                            <th width="10%">{{ translate('Options') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($sellers as $key => $seller)
                            <tr>
                                <td>{{ $key + 1 + ($sellers->currentPage() - 1) * $sellers->perPage() }}</td>

                                <td>
                                    <div class="d-flex align-items-center">
                                        <img src="{{ uploaded_asset($seller->avatar ?? null) }}"
                                            class="size-50px rounded-circle mr-2"
                                            onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';" />
                                        <span class="flex-grow-1 minw-0">
                                            <div class="text-truncate fs-12 fw-600">
                                                {{ $seller->name ?? translate('Deleted User') }}
                                            </div>
                                            <div class="text-truncate fs-12">
                                                {{ translate('Phone') }}: {{ $seller->phone ?? '—' }}
                                            </div>
                                            <div class="text-truncate fs-12">
                                                {{ translate('Email') }}: {{ $seller->email ?? '—' }}
                                            </div>
                                        </span>
                                    </div>
                                </td>

                                <td>
                                    <div>
                                        {{ optional($seller->seller_package)->name ?? translate('No Package') }}
                                    </div>
                                </td>

                                <td>
                                    @php $balance = (float) (optional($seller->user)->current_balance ?? 0); @endphp

                                    @if ($balance == 0)
                                        <div>{{ translate('Due to seller') }}:</div>
                                        <span class="fs-16 fw-700 text-secondary">{{ format_price($balance) }}</span>
                                    @elseif ($balance > 0)
                                        <div>{{ translate('Due to seller') }}:</div>
                                        <span class="fs-16 fw-700 text-danger">{{ format_price($balance) }}</span>
                                    @else
                                        <div>{{ translate('Due from seller') }}:</div>
                                        <span class="fs-16 fw-700 text-success">{{ format_price(abs($balance)) }}</span>
                                    @endif
                                </td>

                                {{-- <td>
                                    <label class="aiz-switch aiz-switch-success mb-0">
                                        <input onchange="seller_approval(this)" value="{{ $seller->id }}" type="checkbox"
                                            @if (($seller->approval ?? 0) == 1) checked @endif>
                                        <span class="slider round"></span>
                                    </label>
                                </td> --}}

                                <td>
                                    @php
                                        $level = (int) (optional($seller->seller_package)->geographic_level ?? 0);
                                        $paymentApproval =
                                            (int) (optional($seller->sellerPackagePayment)->approval ?? 0);
                                        // Can toggle if: package doesn't require payment (level 0) OR payment was approved
                                        $canToggle = $level === 0 || $paymentApproval === 1;
                                    @endphp

                                    <label class="aiz-switch aiz-switch-success mb-0"
                                        @if (!$canToggle) data-toggle="tooltip" title="Disabled until payment is approved." @endif>
                                        <input onchange="seller_approval(this)" value="{{ $seller->id }}" type="checkbox"
                                            @if (($seller->approval ?? 0) == 1) checked @endif
                                            @unless ($canToggle) disabled @endunless>
                                        <span class="slider round"></span>
                                    </label>

                                    @unless ($canToggle)
                                        <div class="text-xs text-muted mt-1">
                                            Payment not approved.
                                        </div>
                                    @endunless
                                </td>


                                <td>
                                    <div class="dropdown">
                                        <button type="button"
                                            class="btn btn-sm btn-circle btn-soft-primary btn-icon dropdown-toggle no-arrow"
                                            data-toggle="dropdown" href="javascript:void(0);" role="button"
                                            aria-haspopup="false" aria-expanded="false">
                                            <i class="las la-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right dropdown-menu-xs">

                                            <a href="#"
                                                onclick="show_seller_profile('{{ $seller->id }}'); return false;"
                                                class="dropdown-item">
                                                {{ translate('Profile') }}
                                            </a>

                                            <a href="#" onclick="show_seller_payment_modal('{{ $seller->id }}');"
                                                class="dropdown-item">
                                                {{ translate('Pay to Seller') }}
                                            </a>

                                            {{-- If your route previously used shop_id, update it to user_id in the routes/controller --}}
                                            <a href="{{ route('admin.seller_payments_history', ['user_id' => $seller->id]) }}"
                                                class="dropdown-item">
                                                {{ translate('Payment History') }}
                                            </a>


                                            <a href="{{ route('admin.seller.edit', encrypt($seller->id)) }}"
                                                class="dropdown-item">
                                                {{ translate('Edit') }}
                                            </a>

                                            @if ($seller->id == 2)
                                                @if (auth()->user()->user_type == 'admin')
                                                    <a href="#" class="dropdown-item confirm-delete"
                                                        data-href="{{ route('admin.seller.destroy', $seller->id) }}">
                                                        {{ translate('Delete') }}
                                                    </a>
                                                @endif
                                            @else
                                                @if (auth()->user()->user_type == 'admin' || auth()->user()->role_id == 10)
                                                    <a href="#" class="dropdown-item confirm-delete"
                                                        data-href="{{ route('admin.seller.destroy', $seller->id) }}">
                                                        {{ translate('Delete') }}
                                                    </a>
                                                @endif
                                            @endif
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                        @if ($sellers->isEmpty())
                            <tr>
                                <td colspan="6" class="text-center text-muted">
                                    {{ translate('No sellers found.') }}
                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>

                <div class="aiz-pagination">
                    {{ $sellers->appends(request()->input())->links() }}
                </div>
            </div>
        </form>
    </div>
@endsection

@section('modal')
    @include('backend.inc.delete_modal')

    <!-- Seller Profile Modal -->
    <div class="modal fade" id="profile_modal">
        <div class="modal-dialog">
            <div class="modal-content" id="profile-modal-content"></div>
        </div>
    </div>

    <!-- Seller Payment Modal -->
    <div class="modal fade" id="payment_modal">
        <div class="modal-dialog">
            <div class="modal-content" id="payment-modal-content"></div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        function seller_approval(el) {
            var status = el.checked ? 1 : 0;
            $.post('{{ route('admin.sellers.approval') }}', {
                _token: '{{ csrf_token() }}',
                id: el.value,
                status: status
            }, function(data) {
                if (data == 1) {
                    AIZ.plugins.notify('success', '{{ translate('Seller approval status successfully') }}');
                } else {
                    AIZ.plugins.notify('danger', '{{ translate('Something went wrong') }}');
                }
            });
        }

        function show_seller_profile(id) {
            $.post('{{ route('admin.sellers.profile_modal') }}', {
                _token: '{{ csrf_token() }}',
                id: id
            }, function(data) {
                $('#profile-modal-content').html(data);
                $('#profile_modal').modal('show', {
                    backdrop: 'static'
                });
            });
        }

        function show_seller_payment_modal(id) {
            $.post('{{ route('admin.sellers.payment_modal') }}', {
                _token: '{{ csrf_token() }}',
                id: id
            }, function(data) {
                $('#payment-modal-content').html(data);
                $('#payment_modal').modal('show', {
                    backdrop: 'static'
                });
            });
        }

        function sort_sellers() {
            $('#sort_sellers').submit();
        }
    </script>
@endsection
