{{-- addon:multivendor::admin/sellers/profile_modal.blade.php --}}
@php
    /** @var \App\Models\User $seller */
    $shop = $seller->shop ?? null;

    // Metrics (safe defaults; only query when shop exists)
    $productCount = 0;
    $totalOrders = 0;
    $totalSoldAmount = 0;

    if ($shop) {
        $productCount = \App\Models\Product::where('shop_id', $shop->id)->count();
        $totalOrders = \App\Models\Order::where('shop_id', $shop->id)->count();
        $totalSoldAmount = \App\Models\Order::where('shop_id', $shop->id)
            ->where('payment_status', 'paid')
            ->sum('grand_total');
    }
@endphp

<div class="modal-body">
    <div class="text-center">
        <span class="avatar avatar-xxl mb-3">
            <img src="{{ uploaded_asset($seller->avatar ?? null) }}"
                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/avatar-place.png') }}';">
        </span>
        <h1 class="h5 mb-1">{{ $seller->name ?? '—' }}</h1>
        <p class="text-sm text-muted">
            {{ optional($seller->seller_package)->name ?? ($seller->seller_type ?? translate('No Package')) }}
        </p>
    </div>
    <hr>

    <!-- Profile Details -->
    <h6 class="mb-4">{{ translate('About') }} {{ $seller->name ?? '' }}</h6>
    <p><i class="demo-pli-internet icon-lg icon-fw mr-1"></i>{{ $seller->email ?? '—' }}</p>
    <p><i class="demo-pli-old-telephone icon-lg icon-fw mr-1"></i>{{ $seller->phone ?? '—' }}</p>

    <h6 class="mb-4 mt-4">{{ translate('Payout Info') }}</h6>
    <p>{{ translate('Bank Name') }} : {{ $seller->bank_name ?? ($shop->bank_name ?? '—') }}</p>
    <p>{{ translate('Bank Acc Name') }} : {{ $seller->bank_acc_name ?? ($shop->bank_acc_name ?? '—') }}</p>
    <p>{{ translate('Bank Acc Number') }} : {{ $seller->bank_acc_no ?? ($shop->bank_acc_no ?? '—') }}</p>
    <p>{{ translate('Bank Routing Number') }} : {{ $seller->bank_routing_no ?? ($shop->bank_routing_no ?? '—') }}</p>

    <br>

    <div class="table-responsive">
        <table class="table table-striped mar-no">
            <tbody>
                <tr>
                    <td>{{ translate('Total Products') }}</td>
                    <td>{{ $productCount }}</td>
                </tr>
                <tr>
                    <td>{{ translate('Total Orders') }}</td>
                    <td>{{ $totalOrders }}</td>
                </tr>
                <tr>
                    <td>{{ translate('Total Sold Amount') }}</td>
                    <td>{{ format_price($totalSoldAmount) }}</td>
                </tr>
            </tbody>
        </table>
        {{-- @if (!$shop)
            <small class="text-muted d-block mt-2">
                {{ translate('No shop found for this user, so totals are shown as 0.') }}
            </small>
        @endif --}}
    </div>
</div>
