@extends('addon:multivendor::seller.layouts.app')

@section('content')
    <div class="row">
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                style="background-color: #f5a100">
                <div class="pb-5">
                    <div class="fw-500 text-white">{{ translate('Referrals') }}</div>
                    <div class="h2 fw-700 text-white">{{ $referralCount }}</div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                style="background-color: #f5a100">
                <div class="pb-5">
                    <div class="fw-500 text-white">{{ translate('Sale Commission') }}</div>
                    <div class="h2 fw-700 text-white">{{ format_price($saleCommision) }}</div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                style="background-color: #f5a100">
                <div class="pb-5">
                    <div class="fw-500 text-white">{{ translate('Referral Commission') }}</div>
                    <div class="h2 fw-700 text-white">{{ format_price($referralCommision) }}</div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                style="background-color: #f5a100">
                <div class="pb-5">
                    <div class="fw-500 text-white">{{ translate('Referral Sale Commission') }}</div>
                    <div class="h2 fw-700 text-white">{{ format_price($referralSaleCommision) }}</div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                style="background-color: #f5a100">
                <div class="pb-5">
                    <div class="fw-500 text-white">{{ translate('Area Sale Bonus') }}</div>
                    <div class="h2 fw-700 text-white">{{ format_price($areaSaleBonus) }}</div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                style="background-color: #f5a100">
                <div class="pb-5">
                    <div class="fw-500 text-white">{{ translate("Today's Earnings") }}</div>
                    <div class="h2 fw-700 text-white">
                        {{ format_price(
                            Auth::user()->commission_histories()->whereDate('created_at', today())->sum('seller_earning'),
                            true,
                        ) }}
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                style="background-color:#f5a100">
                <div class="pb-5">
                    <div class="fw-500 text-white">{{ translate('Current Balance') }}</div>
                    <div class="h2 fw-700 text-white">{{ format_price($currentBalance) }}</div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5 d-flex justify-content-between align-items-end"
                style="background-color: #f5a100">
                <div class="pb-5">
                    <div class="fw-500 text-white">{{ translate('All-Time Earnings') }}</div>
                    <div class="h2 fw-700 text-white">{{ format_price($allTime) }}</div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12 col-md-6">
            <div class="rounded-lg mb-4 pb-4" style="background-color: #FF6F61">
                <div class="px-4 pt-4 pb-3 mb-3 text-white fs-16 fw-700">{{ translate('Sales stat') }}</div>
                <canvas id="graph-1" class="w-100" height="60"></canvas>
            </div>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card overflow-hidden h-100 mb-0">
                <div class="card-body">
                    <div class="fs-16 fw-700">{{ translate('Recent Referrals') }}</div>
                    <ul class="list-group list-group-flush">
                        @foreach ($latestPackagePayments as $payment)
                            <li class="list-group-item d-flex justify-content-end px-0 py-3 lh-1-3">
                                <span class="flex-grow-1 minw-0">
                                    <div class="fw-700">{{ $payment->user->name }}</div>
                                    <div class="opacity-60">{{ $payment->created_at->toFormattedDateString() }}</div>
                                </span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card overflow-hidden h-100 mb-0">
                <div class="card-body">
                    <div class="fs-16 fw-700">{{ translate('Current Package') }}</div>
                    <div class="mb-4 mt-3 border-bottom">
                        <img class="mw-100 mx-auto mb-4" src="{{ uploaded_asset(Auth::user()->seller_package->logo) }}"
                            height="100">
                        <h5 class="mb-3 h5 fw-600">{{ Auth::user()->seller_package->getTranslation('name') }}</h5>
                    </div>
                    <div class="text-center">
                        <a href="{{ route('seller.package_select') }}"
                            class="btn btn-primary">{{ translate('Upgrade Package') }}</a>
                    </div>
                </div>
            </div>
        </div>

        {{-- Delivery status counts --}}
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="rounded-lg p-4 border mb-4 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Order Placed') }}</div>
                    <div class="fs-20 fw-600" style="color: #F0C05A">
                        {{ Auth::user()->orders()->where('delivery_status', 'order_placed')->count() }}
                    </div>
                </div>
            </div>
            <div class="rounded-lg p-4 border mb-4 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Order Packed') }}</div>
                    <div class="fs-20 fw-600" style="color: #7BC4C4">
                        {{ Auth::user()->orders()->where('delivery_status', 'order packed')->count() }}
                    </div>
                </div>
            </div>
            <div class="rounded-lg p-4 border mb-4 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Shipped to Courier') }}</div>
                    <div class="fs-20 fw-600" style="color: #91A8D0">
                        {{ Auth::user()->orders()->where('delivery_status', 'shipped to courier')->count() }}
                    </div>
                </div>
            </div>
            <div class="rounded-lg p-4 border mb-4 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('In Transit') }}</div>
                    <div class="fs-20 fw-600" style="color: #F0C05A">
                        {{ Auth::user()->orders()->where('delivery_status', 'in transit')->count() }}
                    </div>
                </div>
            </div>
            <div class="rounded-lg p-4 border mb-4 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Out for Delivery') }}</div>
                    <div class="fs-20 fw-600" style="color: #7BC4C4">
                        {{ Auth::user()->orders()->where('delivery_status', 'out for delivery')->count() }}
                    </div>
                </div>
            </div>
            <div class="rounded-lg p-4 border bg-light">
                <div class="py-1 d-flex align-items-center">
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Order Delivered') }}</div>
                    <div class="fs-20 fw-600" style="color: #FF6F61">
                        {{ Auth::user()->orders()->where('delivery_status', 'delivered')->count() }}
                    </div>
                </div>
            </div>
        </div>

        {{-- Recent Orders --}}
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card overflow-hidden h-100 mb-0">
                <div class="card-body">
                    <div class="fs-16 fw-700 border-bottom pb-3">{{ translate('Recent Orders') }}</div>
                    <ul class="list-group list-group-flush">
                        @foreach (Auth::user()->orders()->latest()->limit(8)->get() as $order)
                            <li class="list-group-item d-flex justify-content-end px-0 py-3 lh-1-3">
                                <span class="flex-grow-1 minw-0">
                                    <div class="fw-700">{{ $order->combined_order->code }}</div>
                                    <div class="opacity-60">
                                        {{ $order->combined_order->created_at->toFormattedDateString() }}
                                    </div>
                                </span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('script')
    <script>
        let draw = Chart.controllers.line.prototype.draw;
        Chart.controllers.line = Chart.controllers.line.extend({
            draw: function() {
                draw.apply(this, arguments);
                let ctx = this.chart.chart.ctx;
                let _stroke = ctx.stroke;
                ctx.stroke = function() {
                    ctx.save();
                    ctx.shadowColor = 'rgb(0, 0, 0, .16)';
                    ctx.shadowBlur = 3;
                    ctx.shadowOffsetX = 0;
                    ctx.shadowOffsetY = 3;
                    _stroke.apply(this, arguments)
                    ctx.restore();
                }
            }
        });

        AIZ.plugins.chart('#graph-1', {
            type: 'line',
            data: {
                labels: ["JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"],
                datasets: [{
                    data: [
                        {{ $cached_graph_data['sales_number_per_month'][1] }},
                        {{ $cached_graph_data['sales_number_per_month'][2] }},
                        {{ $cached_graph_data['sales_number_per_month'][3] }},
                        {{ $cached_graph_data['sales_number_per_month'][4] }},
                        {{ $cached_graph_data['sales_number_per_month'][5] }},
                        {{ $cached_graph_data['sales_number_per_month'][6] }},
                        {{ $cached_graph_data['sales_number_per_month'][7] }},
                        {{ $cached_graph_data['sales_number_per_month'][8] }},
                        {{ $cached_graph_data['sales_number_per_month'][9] }},
                        {{ $cached_graph_data['sales_number_per_month'][10] }},
                        {{ $cached_graph_data['sales_number_per_month'][11] }},
                        {{ $cached_graph_data['sales_number_per_month'][12] }}
                    ],
                    fill: false,
                    borderColor: "rgb(221, 65, 36)",
                    borderWidth: 4,
                }]
            },
            options: {
                legend: {
                    display: false
                },
                scales: {
                    yAxes: [{
                        display: false,
                        ticks: {
                            min: 0,
                            max: 150,
                        },
                    }],
                    xAxes: [{
                        display: false,
                    }],
                    ticks: {
                        min: 0
                    },
                },
            }
        })

        AIZ.plugins.chart('#graph-2', {
            type: 'bar',
            data: {
                labels: ["JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"],
                datasets: [{
                    label: '{{ translate('Sales ($)') }}',
                    data: [
                        {{ $cached_graph_data['sales_amount_per_month'][1] }},
                        {{ $cached_graph_data['sales_amount_per_month'][2] }},
                        {{ $cached_graph_data['sales_amount_per_month'][3] }},
                        {{ $cached_graph_data['sales_amount_per_month'][4] }},
                        {{ $cached_graph_data['sales_amount_per_month'][5] }},
                        {{ $cached_graph_data['sales_amount_per_month'][6] }},
                        {{ $cached_graph_data['sales_amount_per_month'][7] }},
                        {{ $cached_graph_data['sales_amount_per_month'][8] }},
                        {{ $cached_graph_data['sales_amount_per_month'][9] }},
                        {{ $cached_graph_data['sales_amount_per_month'][10] }},
                        {{ $cached_graph_data['sales_amount_per_month'][11] }},
                        {{ $cached_graph_data['sales_amount_per_month'][12] }}
                    ],
                    backgroundColor: '#DD4124',
                    borderColor: '#DD4124',
                    borderWidth: 1,
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        gridLines: {
                            color: '#fff',
                            zeroLineColor: '#f2f3f8'
                        },
                        ticks: {
                            fontColor: "#8b8b8b",
                            fontFamily: 'Roboto',
                            fontSize: 10,
                            beginAtZero: true,
                            callback: function(value, index, values) {
                                return value.toLocaleString('en-PH', {
                                    style: 'currency',
                                    currency: 'PHP'
                                });
                            }
                        },
                    }],

                    xAxes: [{
                        gridLines: {
                            color: '#fff'
                        },
                        ticks: {
                            fontColor: "#8b8b8b",
                            fontFamily: 'Roboto',
                            fontSize: 10
                        },
                        barThickness: 20,
                        barPercentage: .5,
                        categoryPercentage: .5,
                    }],
                },

                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            let label = data.datasets[tooltipItem.datasetIndex].label || '';
                            if (label === 'Sales ($)') {
                                label = 'Sales: ';
                            } else if (label) {
                                label += ': ';
                            }
                            label += tooltipItem.yLabel.toLocaleString('en-PH', {
                                style: 'currency',
                                currency: 'PHP'
                            });
                            return label;
                        }
                    }
                },

                legend: {
                    display: false
                }
            }
        });
    </script>
@endsection
