<div class="aiz-topbar border-bottom px-15px px-lg-25px d-flex align-items-stretch justify-content-between">
    <div class=" d-flex">
        <div class="aiz-topbar-logo-wrap w-xl-240px d-flex align-items-center justify-content-start">
            <a href="{{ route('seller.dashboard') }}" class="d-block">
                {{-- @if ($logo != null)
                    <img src="{{ uploaded_asset($logo) }}" class="brand-icon" alt="{{ get_setting('site_name') }}">
                @else --}}
                <img src="{{ static_asset('assets/img/logo.png') }}" class="brand-icon"
                    alt="{{ get_setting('site_name') }}" style="width: 174px; height: 73px; padding: 10px;">
                {{-- @endif --}}
            </a>
        </div>
        <div class="aiz-topbar-nav-toggler d-flex align-items-center justify-content-start mx-2 mx-md-3"
            data-toggle="aiz-mobile-nav">
            <button
                class="btn btn-icon btn-outline-secondary border-gray-300 p-0 d-flex align-items-center justify-content-center">
                <span class="aiz-mobile-toggler d-inline-block">
                    <span></span>
                </span>
            </button>
        </div>
    </div>
    <div class="d-flex justify-content-between align-items-stretch flex-grow-xl-1">
        <div class="d-flex justify-content-around align-items-center align-items-stretch">
            <div class="aiz-topbar-item align-items-center">
                <a href="#"
                    class="btn btn-outline-secondary border-gray-300 d-flex align-items-center px-3 bg-warning fw-500 copy-seller-shop-url"
                    data-user-id="{{ Auth::id() }}" data-toggle="tooltip" data-placement="bottom"
                    title="{{ translate('Share My Shop') }}">
                    <i class="las la-store"></i>
                </a>

            </div>
            <div class="aiz-topbar-item align-items-center ml-3">
                <a href="#"
                    class="btn btn-outline-secondary border-gray-300 d-flex align-items-center px-3 bg-warning fw-500 copy-seller-shop-url"
                    data-user-id="{{ Auth::id() }}" data-fragment="membership-packages" data-toggle="tooltip"
                    data-placement="bottom" title="{{ translate('Share My Referral Link') }}">
                    <i class="las la-network-wired"></i>
                </a>

            </div>
        </div>
        <div class="d-flex justify-content-around align-items-center align-items-stretch">
            <div class="aiz-topbar-item ml-3 mr-0">
                <div class="align-items-center d-flex dropdown">
                    <a class="dropdown-toggle no-arrow text-dark" data-toggle="dropdown" href="javascript:void(0);"
                        role="button" aria-haspopup="false" aria-expanded="false">
                        <span class="d-flex align-items-center">
                            <span class="d-none d-md-block">
                                <span class="d-block fw-500">{{ Auth::user()->name }}</span>
                                <span class="d-block small opacity-60">{{ ucfirst(Auth::user()->seller_type) }}</span>
                            </span>
                            <span class="avatar avatar-sm ml-md-2 mr-0">
                                <img src="{{ uploaded_asset(Auth::user()->avatar) }}"
                                    onerror="this.onerror=null;this.src='{{ static_asset('assets/img/avatar-place.png') }}';">
                            </span>
                        </span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-md">
                        <a href="{{ route('seller.profile') }}" class="dropdown-item">
                            <i class="las la-user-circle"></i>
                            <span>{{ translate('Profile') }}</span>
                        </a>

                        <a href="{{ route('logout') }}" class="dropdown-item">
                            <i class="las la-sign-out-alt"></i>
                            <span>{{ translate('Logout') }}</span>
                        </a>
                    </div>
                </div>
            </div><!-- .aiz-topbar-item -->
        </div>
    </div>
</div><!-- .aiz-topbar -->

@section('script')
    {{-- <script type="text/javascript">
        function copyShopUrl(sellerShopId, fragment) {
            var homepageUrl = "{{ env('HOMEPAGE_URL') }}";

            if (!homepageUrl) return;

            var url = homepageUrl + "/shop?sellerid=" + sellerShopId + (fragment ? "#" + fragment : "");

            navigator.clipboard.writeText(url).then(() => {
                $.get("{{ route('link.copied') }}");
            }).catch(err => {
                console.error("Failed to copy:", err);
            });
        }

        $(document).ready(function() {
            $(document).on('click', '.copy-seller-shop-url', function() {
                copyShopUrl($(this).data('seller-shopid'), $(this).data('fragment'));
            });
        });
    </script> --}}

    <script type="text/javascript">
        function copyShopUrl(userId, fragment) {
            var homepageUrl = "{{ env('HOMEPAGE_URL') }}";
            if (!homepageUrl) return;

            var url = homepageUrl + "/?sellerid=" + userId + (fragment ? "#" + fragment : "");

            navigator.clipboard.writeText(url)
                .then(() => {
                    $.get("{{ route('link.copied') }}");
                    AIZ.plugins.notify('success', 'Link copied successfully!');
                })
                .catch(err => {
                    console.error("Failed to copy:", err);
                    AIZ.plugins.notify('danger', 'Failed to copy link.');
                });
        }

        $(document).ready(function() {
            $(document).on('click', '.copy-seller-shop-url', function(e) {
                e.preventDefault();
                copyShopUrl($(this).data('user-id'), $(this).data('fragment'));
            });
        });
    </script>
@endsection
