@extends('addon:multivendor::seller.layouts.app')

@section('content')

    @php
        $posCart = (array) Session::get('pos.cart', []);
    @endphp

    @if (count($posCart))
        @foreach ($posCart as $key => $cartItem)
            {{-- existing rows --}}
        @endforeach
    @else
        {{-- empty state --}}
    @endif


    <section class="">
        @php
            $user = auth()->user();
        @endphp

        @if (!$user->ship_to_other && empty($user->address))
            <div class="alert alert-danger d-flex align-items-center justify-content-between">
                <span>{{ translate('Your Shipping Address has not been set. Please set it before making any orders.') }}</span>
                <button type="button"
                    class="btn btn-outline-secondary border-gray-300 d-flex align-items-center px-3 bg-warning fw-500"
                    data-target="#new-address-modal" data-toggle="modal">
                    {{ translate('Set It Now') }}
                </button>
            </div>
        @else
            <div class="alert alert-info d-flex align-items-center justify-content-between">
                <span>
                    @if ($user->ship_to_other)
                        {{ translate('You are shipping to a recipient:') }}
                        <strong>{{ $user->recipient_name }}</strong>
                        — {{ $user->recipient_phone }}<br>
                        {{ translate('Address:') }} {{ $user->recipient_address }}
                    @else
                        {{ translate('Your current shipping info is set.') }}<br>
                        {{ translate('Address:') }} {{ $user->address }}
                    @endif
                </span>
                <button type="button"
                    class="btn btn-outline-secondary border-gray-300 d-flex align-items-center px-3 bg-warning fw-500"
                    data-target="#new-address-modal" data-toggle="modal">
                    {{ $user->ship_to_other ? translate('Change Recipient / Address') : translate('Change Settings') }}
                </button>
            </div>
        @endif

        <form class="" action="" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row gutters-5">
                <div class="col-md pr-3">
                    <div class="row gutters-5 mb-3">
                        <div class="col-md-6 mb-2 mb-md-0">
                            <div class="form-group mb-0">
                                <input class="form-control form-control-lg" type="text" name="keyword"
                                    placeholder="{{ translate('Search by Product Name') }}" onkeyup="filterProducts()">
                            </div>
                        </div>
                    </div>
                    <div class="aiz-pos-product-list c-scrollbar-light">
                        <div class="d-flex flex-wrap justify-content-start" id="product-list"></div>
                        <div id="load-more" class="text-center">
                            <div class="fs-14 d-inline-block fw-600 btn btn-soft-primary c-pointer"
                                onclick="loadMoreProduct()">{{ translate('Loading..') }}</div>
                        </div>
                    </div>
                </div>

                <div class="col-md-auto w-md-350px w-lg-400px w-xl-500px">
                    <div class="card mb-3 bg-pos-gray">
                        <div class="card-body">
                            <div id="cart-details">
                                <div class="aiz-pos-cart-list mb-4 mt-3 c-scrollbar-light">
                                    @php
                                        $posCart = (array) Session::get('pos.cart', []);
                                        $subtotal = 0;
                                        // $discount already passed in
                                    @endphp

                                    @if (count($posCart))
                                        <ul class="list-group list-group-flush">
                                            @forelse ($posCart as $key => $cartItem)
                                                @php
                                                    $price = (float) ($cartItem['price'] ?? 0);
                                                    $qty = (int) ($cartItem['quantity'] ?? 0);
                                                    $prodId = (int) ($cartItem['id'] ?? 0);
                                                    $product = $prodId ? \App\Models\Product::find($prodId) : null;
                                                    $subtotal += $price * $qty;
                                                @endphp
                                                <!-- your <li> … content unchanged -->
                                            @empty
                                                <li class="list-group-item">
                                                    <div class="text-center">
                                                        <i class="las la-frown la-3x opacity-50"></i>
                                                        <p>{{ translate('No Product Added') }}</p>
                                                    </div>
                                                </li>
                                            @endforelse
                                        </ul>
                                    @else
                                        <div class="text-center">
                                            <i class="las la-frown la-3x opacity-50"></i>
                                            <p>{{ translate('No Product Added') }}</p>
                                        </div>
                                    @endif
                                </div>
                                <div>
                                    <div class="d-flex justify-content-between fw-600 mb-2 opacity-70">
                                        <span>{{ translate('Sub Total') }}</span>
                                        <span>{{ single_price($subtotal) }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between fw-600 mb-2 opacity-70">
                                        <span>{{ translate('Discount') }}</span>
                                        <span>{{ $discount }}%</span>
                                    </div>
                                    <div class="d-flex justify-content-between fw-600 fs-18 border-top py-3">
                                        <span>{{ translate('Total') }}</span>
                                        <span>{{ single_price($subtotal - ($subtotal * $discount) / 100) }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="pos-footer mar-btm">
                                <div class="justify-content-between">
                                    <div class="my-2 my-md-0">
                                        <button type="button"
                                            class="btn btn-primary btn-block h-60px fs-20 font-weight-bold"
                                            onclick="orderConfirmation()">{{ translate('Place Order') }}</button>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </form>
    </section>
@endsection

@section('modal')
    <!-- Address Modal (unused container kept) -->
    <div id="new-customer" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-dialog-zoom" role="document">
            <div class="modal-content">
                <div class="modal-header bord-btm">
                    <h4 class="modal-title h6">{{ translate('Shipping Address') }}</h4>
                    <button type="button" class="close" data-dismiss="modal"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <form id="shipping_form">
                    <div class="modal-body" id="shipping_address"></div>
                </form>
                <div class="modal-footer">
                    <button type="button" class="btn btn-styled btn-base-3" data-dismiss="modal"
                        id="close-button">{{ translate('Close') }}</button>
                    <button type="button" class="btn btn-primary btn-styled btn-base-1" id="confirm-address"
                        data-dismiss="modal">{{ translate('Confirm') }}</button>
                </div>
            </div>
        </div>
    </div>

    <!-- New / Change address & recipient modal -->
    <div id="new-address-modal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-dialog-zoom" role="document">
            <div class="modal-content">
                <div class="modal-header bord-btm">
                    <h4 class="modal-title h6">{{ translate('Shipping Address') }}</h4>
                    <button type="button" class="close" data-dismiss="modal"><span
                            aria-hidden="true">&times;</span></button>
                </div>

                <form class="form-horizontal" action="{{ route('seller.store_shipping') }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="customer_id" id="set_customer_id" value="">

                        {{-- Toggle: Send to friend/family --}}
                        <div class="form-group">
                            <div class="row align-items-center">
                                <div class="col-sm-12">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="ship_to_other"
                                            name="ship_to_other" value="1"
                                            {{ old('ship_to_other', $user->ship_to_other) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="ship_to_other">
                                            {{ translate('Send to a friend or family (use recipient info)') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Recipient fields --}}
                        <div class="recipient-fields" style="display:none;">
                            <div class="form-group">
                                <div class="row">
                                    <label class="col-sm-2 control-label"
                                        for="recipient_name">{{ translate('Recipient Name') }}</label>
                                    <div class="col-sm-10">
                                        <input type="text" id="recipient_name" name="recipient_name"
                                            class="form-control"
                                            value="{{ old('recipient_name', $user->recipient_name) }}">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="row">
                                    <label class="col-sm-2 control-label"
                                        for="recipient_phone">{{ translate('Recipient Phone') }}</label>
                                    <div class="col-sm-10">
                                        <input type="tel" id="recipient_phone" name="recipient_phone"
                                            class="form-control"
                                            value="{{ old('recipient_phone', $user->recipient_phone) }}"
                                            placeholder="{{ translate('e.g. 09XXXXXXXXX') }}">
                                        <small class="form-text text-muted">
                                            {{ translate('Use an active mobile number for delivery updates.') }}
                                        </small>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="row">
                                    <label class="col-sm-2 control-label"
                                        for="recipient_address">{{ translate('Recipient Address') }}</label>
                                    <div class="col-sm-10">
                                        <textarea id="recipient_address" name="recipient_address" class="form-control"
                                            placeholder="{{ translate('Street, Barangay, City/Municipality, Province') }}">{{ old('recipient_address', $user->recipient_address) }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Own address fields --}}
                        <div class="own-address-fields" style="display:none;">
                            <div class="form-group">
                                <div class="row">
                                    <label class="col-sm-2 control-label"
                                        for="address">{{ translate('Your Address') }}</label>
                                    <div class="col-sm-10">
                                        <textarea id="address" name="address" class="form-control"
                                            placeholder="{{ translate('e.g. Street #, Barangay, City/Municipality, Province') }}">{{ old('address', $user->address) }}</textarea>
                                        <small class="form-text text-muted">
                                            {{ translate('Please follow this format: Street, Barangay, City/Municipality, Province.') }}
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div> {{-- /.modal-body --}}

                    <div class="modal-footer">
                        <button type="button" class="btn btn-styled btn-base-3"
                            data-dismiss="modal">{{ translate('Close') }}</button>
                        <button type="submit"
                            class="btn btn-primary btn-styled btn-base-1">{{ translate('Save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- order summary modal -->
    <div id="order-confirm" class="modal fade">
        <div class="modal-dialog modal-dialog-centered modal-dialog-zoom modal-xl">
            <div class="modal-content" id="variants">
                <div class="modal-header bord-btm">
                    <h4 class="modal-title h6">{{ translate('Order Summary') }}</h4>
                    <button type="button" class="close" data-dismiss="modal"><span
                            aria-hidden="true">×</span></button>
                </div>
                <div class="modal-body" id="order-confirmation">
                    <div class="p-4 text-center">
                        <i class="las la-spinner la-spin la-3x"></i>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-base-3"
                        data-dismiss="modal">{{ translate('Close') }}</button>
                    <button type="button" onclick="submitOrder('cash_on_delivery')"
                        class="btn btn-base-1 btn-info">{{ translate('Confirm Order') }}</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        // Toggle recipient vs own-address UI + required fields
        function toggleRecipientUI() {
            var checked = document.getElementById('ship_to_other').checked;
            var recip = document.querySelector('.recipient-fields');
            var own = document.querySelector('.own-address-fields');

            recip.style.display = checked ? '' : 'none';
            own.style.display = checked ? 'none' : '';

            // required toggles
            var rn = document.getElementById('recipient_name');
            var rp = document.getElementById('recipient_phone');
            var ra = document.getElementById('recipient_address');
            var ad = document.getElementById('address');
            rn && rn.toggleAttribute('required', checked);
            rp && rp.toggleAttribute('required', checked);
            ra && ra.toggleAttribute('required', checked);
            ad && ad.toggleAttribute('required', !checked);
        }

        document.addEventListener('DOMContentLoaded', function() {
            var cb = document.getElementById('ship_to_other');
            if (cb) {
                cb.addEventListener('change', toggleRecipientUI);
                toggleRecipientUI();
            }
        });

        var products = null;

        $(document).ready(function() {
            $('#product-list').on('click', '.add-plus:not(.c-not-allowed)', function() {
                var product_id = $(this).data('product_id');
                $.post('{{ route('seller.addToCart') }}', {
                    _token: AIZ.data.csrf,
                    product_id: product_id
                }, function(data) {
                    if (data.success == 1) {
                        updateCart(data.view);
                    } else {
                        AIZ.plugins.notify('danger', data.message);
                    }
                });
            });
            filterProducts();
        });

        function updateCart(data) {
            $('#cart-details').html(data);
            AIZ.extra.plusMinus();
        }

        function filterProducts() {
            var keyword = $('input[name=keyword]').val();
            $.get('{{ route('seller.search_product') }}', {
                keyword: keyword
            }, function(data) {
                products = data;
                $('#product-list').html(null);
                setProductList(data);
            });
        }

        function loadMoreProduct() {
            if (products != null && products.links.next != null) {
                $('#load-more').find('.btn').html('{{ translate('Loading..') }}');
                $.get(products.links.next, {}, function(data) {
                    products = data;
                    setProductList(data);
                });
            }
        }

        function setProductList(data) {
            for (var i = 0; i < data.data.length; i++) {
                $('#product-list').append(
                    `<div class="w-140px w-xl-180px w-xxl-210px mr-2">
    <div class="card bg-white c-pointer product-card hov-container">
        <div class="position-relative">
            <span class="absolute-top-left mt-1 ml-1 mr-0">
                ${data.data[i].qty > 0
                    ? `<span class="badge badge-inline badge-success fs-13">{{ translate('In stock') }}</span>`
                    : `<span class="badge badge-inline badge-danger fs-13">{{ translate('Out of stock') }}</span>`}
            </span>
            <img src="${data.data[i].thumbnail_image}" class="card-img-top img-fit h-120px h-xl-180px h-xxl-210px mw-100 mx-auto">
        </div>
        <div class="card-body p-2 p-xl-3">
            <div class="text-truncate fw-600 fs-14 mb-2">${data.data[i].name}</div>
            <div><span>${data.data[i].price}</span></div>
        </div>
        <div class="add-plus absolute-full rounded overflow-hidden hov-box ${data.data[i].qty <= 0 ? 'c-not-allowed' : ''}" data-product_id="${data.data[i].id}">
            <div class="absolute-full bg-dark opacity-50"></div>
            <i class="las la-plus absolute-center la-6x text-white"></i>
        </div>
    </div>
</div>`
                );
            }
            if (data.links.next != null) {
                $('#load-more').find('.btn').html('{{ translate('Load More.') }}');
            } else {
                $('#load-more').find('.btn').html('{{ translate('Nothing more found.') }}');
            }
        }

        function removeFromCart(key) {
            $.post('{{ route('seller.removeFromCart') }}', {
                _token: AIZ.data.csrf,
                key: key
            }, function(data) {
                updateCart(data);
            });
        }

        function addToCart(product_id, variant, quantity) {
            $.post('{{ route('seller.addToCart') }}', {
                _token: AIZ.data.csrf,
                product_id: product_id,
                quantity: quantity,
            }, function(data) {
                $('#cart-details').html(data);
                $('#product-variation').modal('hide');
            });
        }

        function updateQuantity(key) {
            $.post('{{ route('seller.updateQuantity') }}', {
                _token: AIZ.data.csrf,
                key: key,
                quantity: $('#qty-' + key).val()
            }, function(data) {
                if (data.success == 1) {
                    updateCart(data.view);
                } else {
                    AIZ.plugins.notify('danger', data.message);
                }
            });
        }

        function orderConfirmation() {
            $('#order-confirmation').html(
                `<div class="p-4 text-center"><i class="las la-spinner la-spin la-3x"></i></div>`);
            $('#order-confirm').modal('show');
            $.post('{{ route('seller.getOrderSummary') }}', {
                _token: AIZ.data.csrf
            }, function(data) {
                $('#order-confirmation').html(data);
            });
        }

        function submitOrder(payment_type) {
            var user_id = $('select[name=user_id]').val();
            var shipping = $('input[name=shipping]:checked').val();
            var discount = $('input[name=discount]').val();
            var shipping_address = $('input[name=address_id]:checked').val();
            var offline_payment_method = $('input[name=offline_payment_method]').val();
            var offline_payment_amount = $('input[name=offline_payment_amount]').val();
            var offline_trx_id = $('input[name=trx_id]').val();
            var offline_payment_proof = $('input[name=payment_proof]').val();

            $.post('{{ route('seller.order_place') }}', {
                _token: AIZ.data.csrf,
                user_id: user_id,
                shipping_address: shipping_address,
                payment_type: payment_type,
                shipping: shipping,
                discount: discount,
                offline_payment_method: offline_payment_method,
                offline_payment_amount: offline_payment_amount,
                offline_trx_id: offline_trx_id,
                offline_payment_proof: offline_payment_proof
            }, function(data) {
                if (data.success == 1) {
                    AIZ.plugins.notify('success', data.message);
                    location.reload();
                } else {
                    AIZ.plugins.notify('danger', data.message);
                }
            });

            function add_new_address() {
                var customer_id = $('#customer_id').val();
                $('#set_customer_id').val(customer_id);
                $('#new-address-modal').modal('show');
                $("#close-button").click();
            }
        }
    </script>
@endsection
