@extends('addon:multivendor::seller.layouts.app')

@section('content')
    <div class="px-15px px-lg-25px">
        <div class="row gutters-5">
            <div class="col-lg">
                <div class="card">
                    <div class="card-header">
                        <h1 class="h2 fs-18 mb-0">
                            {{ translate('Order Details') }}
                        </h1>
                    </div>

                    {{-- Top info rows --}}
                    <div class="card-header">
                        <div class="flex-grow-1 row">
                            <div class="col-md mb-3">
                                <div>
                                    <div class="fs-15 fw-600 mb-2">{{ translate('Customer info') }}</div>
                                    <div>
                                        <span class="opacity-80 mr-2 ml-0">{{ translate('Name') }}:</span>
                                        {{ $order->name ?? '' }}
                                    </div>
                                    <div>
                                        <span class="opacity-80 mr-2 ml-0">{{ translate('Email') }}:</span>
                                        {{ $order->email ?? '' }}
                                    </div>
                                    <div>
                                        <span class="opacity-80 mr-2 ml-0">{{ translate('Phone') }}:</span>
                                        {{ $order->phone ?? '' }}
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3 ml-auto mr-0 mb-3">
                                <label>{{ translate('Payment Status') }}</label>:
                                @if ($order->payment_status === 'paid')
                                    <span class="badge badge-inline badge-success">{{ translate('Paid') }}</span>
                                @else
                                    <span class="badge badge-inline badge-danger">{{ translate('Unpaid') }}</span>
                                @endif
                            </div>

                            <div class="col-md-3 mb-3">
                                <label>{{ translate('Delivery Status') }}</label>:
                                <span class="text-capitalize">
                                    {{ translate(str_replace('_', ' ', $order->delivery_status ?? '')) }}
                                </span>
                            </div>
                        </div>
                    </div>

                    {{-- Ship To + Billing + meta --}}
                    <div class="card-header">
                        <div class="flex-grow-1 row align-items-start">
                            @php
                                $user = optional($order->user);
                                $shipToOther = (int) ($user->ship_to_other ?? 0) === 1; // use USER flag only
                                // choose recipient fields: user -> fall back to order holder
                                $recName = $shipToOther ? $user->recipient_name ?? '-' : $order->name ?? '-';
                                $recPhone = $shipToOther ? $user->recipient_phone ?? '-' : $order->phone ?? '-';
                                $recAddress = $shipToOther
                                    ? $user->recipient_address ?? '-'
                                    : $order->shipping_address ?? '-';
                            @endphp

                            @if ((int) ($order->code ?? 0) === 1)
                                {{-- POS order: show recipient-aware "Ship To" card --}}
                                <div class="col-md-auto w-md-250px">
                                    <h5 class="fs-14 mb-3">
                                        {{ translate('Ship To') }}
                                        @if ($shipToOther)
                                            {{ translate('Friend/Family') }}
                                        @endif
                                    </h5>
                                    <address class="">
                                        <div>
                                            <span class="opacity-80">{{ translate('Name') }}:</span>
                                            {{ $recName ?: '-' }}
                                        </div>
                                        <div>
                                            <span class="opacity-80">{{ translate('Phone') }}:</span>
                                            {{ $recPhone ?: '-' }}
                                        </div>
                                        <div class="mt-1">
                                            <span class="opacity-80">{{ translate('Address') }}:</span><br>
                                            {{ $recAddress ?: '-' }}
                                        </div>

                                        @if ($shipToOther)
                                            <small class="d-block mt-2 opacity-70">
                                                {{ translate('Notifications are sent to the account email:') }}
                                                <strong>{{ $order->email }}</strong>
                                            </small>
                                        @endif
                                    </address>
                                </div>
                            @else
                                {{-- Non-POS order (code is null or not 1): show original address block --}}
                                <div class="col-md-auto w-md-250px">
                                    <h5 class="fs-14 mb-3">{{ translate('Shipping address') }}</h5>
                                    <address class="">{{ $order->shipping_address }}</address>
                                </div>
                            @endif

                            {{-- Billing --}}
                            <div class="col-md-auto w-md-250px">
                                <h5 class="fs-14 mb-3">{{ translate('Billing address') }}</h5>
                                <address class="mb-0">
                                    {{ $order->billing_address }}
                                </address>
                            </div>

                            {{-- Meta --}}
                            <div class="col-md-4 col-xl-3 ml-auto mr-0">
                                <table class="table table-borderless table-sm">
                                    <tbody>
                                        <tr>
                                            <td class="">{{ translate('Order code') }}</td>
                                            <td class="text-right text-info fw-700">
                                                {{ optional($order->combined_order)->code ?? $order->code }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="">{{ translate('Order Date') }}</td>
                                            <td class="text-right fw-700">
                                                {{ optional($order->created_at)->format('d.m.Y') }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="">{{ translate('Delivery type') }}</td>
                                            <td class="text-right fw-700">
                                                {{ ucfirst(str_replace('_', ' ', $order->delivery_type ?? '')) }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="">{{ translate('Payment method') }}</td>
                                            <td class="text-right fw-700">
                                                {{ ucfirst(str_replace('_', ' ', $order->payment_type ?? '')) }}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>

                    {{-- Items table --}}
                    <div class="card-body">
                        <table class="aiz-table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center" width="5%" data-breakpoints="lg">#</th>
                                    <th width="40%">{{ translate('Product') }}</th>
                                    <th class="text-center" data-breakpoints="lg">{{ translate('Qty') }}</th>
                                    <th class="text-center" data-breakpoints="lg">{{ translate('Unit Price') }}</th>
                                    <th class="text-center" data-breakpoints="lg">{{ translate('Total') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($order->orderDetails as $key => $orderDetail)
                                    <tr>
                                        <td class="text-center">{{ $key + 1 }}</td>
                                        <td>
                                            @if (!empty($orderDetail->product))
                                                <div class="media">
                                                    <img src="{{ uploaded_asset($orderDetail->product->thumbnail_img) }}"
                                                        class="size-60px mr-3"
                                                        onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';">
                                                    <div class="media-body">
                                                        <h4 class="fs-14 fw-400">{{ $orderDetail->product->name }}</h4>

                                                        {{-- SAFE VARIATIONS BLOCK --}}
                                                        @php
                                                            $combinations = data_get(
                                                                $orderDetail,
                                                                'variation.combinations',
                                                                [],
                                                            );
                                                            if (!is_iterable($combinations)) {
                                                                if (is_string($combinations)) {
                                                                    $decoded = json_decode($combinations, true);
                                                                    $combinations = is_array($decoded) ? $decoded : [];
                                                                } else {
                                                                    $combinations = [];
                                                                }
                                                            }
                                                        @endphp

                                                        @if (!empty($combinations))
                                                            <div>
                                                                @foreach ($combinations as $combination)
                                                                    @php
                                                                        $attrName = data_get(
                                                                            $combination,
                                                                            'attribute.name',
                                                                            data_get($combination, 'attribute', ''),
                                                                        );
                                                                        $valueName = data_get(
                                                                            $combination,
                                                                            'attribute_value.name',
                                                                            data_get($combination, 'value', ''),
                                                                        );
                                                                    @endphp
                                                                    @if ($attrName !== '' || $valueName !== '')
                                                                        <span class="mr-2">
                                                                            <span
                                                                                class="opacity-50">{{ $attrName }}</span>:
                                                                            {{ $valueName }}
                                                                        </span>
                                                                    @endif
                                                                @endforeach
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            @else
                                                <strong>{{ translate('Product Unavailable') }}</strong>
                                            @endif
                                        </td>
                                        <td class="text-center">{{ $orderDetail->quantity }}</td>
                                        <td class="text-center">{{ format_price($orderDetail->price) }}</td>
                                        <td class="text-center">{{ format_price($orderDetail->total) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                        {{-- Totals --}}
                        {{-- <div class="row">
                            <div class="col-xl-4 col-md-6 ml-auto mr-0">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <td><strong>{{ translate('Sub Total') }} :</strong></td>
                                            <td>{{ format_price($order->orderDetails->sum('total')) }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>{{ translate('Discount') }} :</strong></td>
                                            <td>
                                                - {{ $discount }}%
                                                @php
                                                    $originalAmount = $order->orderDetails->sum('total');
                                                    $discountAmount = ($discount / 100) * $originalAmount;
                                                @endphp
                                                ({{ format_price($discountAmount) }})
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>{{ translate('Shipping') }} :</strong></td>
                                            <td>{{ format_price($order->shipping_cost) }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>{{ translate('TOTAL') }} :</strong></td>
                                            <td class="h4">{{ format_price($order->grand_total) }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div> --}}

                    </div>
                </div>
            </div>

            {{-- Right column --}}
            <div class="col col-lg-auto w-lg-300px">
                {{-- Tracking info --}}
                <div class="card">
                    <div class="card-header">
                        <h3 class="fs-16 mb-0">{{ translate('Tracking information') }}</h3>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Courier name') }}:</label>
                            <div class="p-2 bg-soft-secondary rounded">{{ $order->courier_name }}</div>
                        </div>
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Tracking number') }}:</label>
                            <div class="p-2 bg-soft-secondary rounded">{{ $order->tracking_number }}</div>
                        </div>
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Tracking url') }}:</label>
                            <div class="p-2 bg-soft-secondary rounded">{{ $order->tracking_url }}</div>
                        </div>
                    </div>
                </div>

                {{-- Order updates --}}
                <div class="card">
                    <div class="card-header">
                        <h3 class="fs-16 mb-0">{{ translate('Order updates') }}</h3>
                    </div>
                    <div class="card-body">
                        @php
                            // Prefer correct relation name; fall back to legacy typo.
                            $updates = $order->order_updates ?? ($order->order_udpates ?? collect());
                            if (!is_iterable($updates)) {
                                $updates = collect();
                            }
                        @endphp

                        @forelse ($updates as $order_update)
                            <div class="mb-3">
                                <div class="p-2 bg-soft-secondary rounded">
                                    {{ $order_update->translatable_note ?? false ? translate($order_update->note) : $order_update->note }}
                                </div>
                                <span class="fs-12 opacity-60">
                                    {{ translate('by') . ' ' . (optional($order_update->user)->name ?? translate('Deleted user')) . ' ' . translate('at') . ' ' . optional($order_update->created_at)->format('h:ia, d-m-Y') }}
                                </span>
                            </div>
                        @empty
                            <div class="text-muted fs-13">{{ translate('No updates yet.') }}</div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        $('#update_delivery_status').on('change', function() {
            var order_id = {{ $order->id }};
            var status = $('#update_delivery_status').val();
            $.post('{{ route('seller.orders.update_delivery_status') }}', {
                _token: '{{ @csrf_token() }}',
                order_id: order_id,
                status: status
            }, function() {
                AIZ.plugins.notify('success', '{{ translate('Delivery status has been updated') }}');
            });
        });

        $('#update_payment_status').on('change', function() {
            var order_id = {{ $order->id }};
            var status = $('#update_payment_status').val();
            $.post('{{ route('seller.orders.update_payment_status') }}', {
                _token: '{{ @csrf_token() }}',
                order_id: order_id,
                status: status
            }, function() {
                AIZ.plugins.notify('success', '{{ translate('Payment status has been updated') }}');
            });
        });
    </script>
@endsection
