@extends('addon:multivendor::seller.layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6">{{ translate('Package Payments') }}</h5>
        </div>
        @php
            $latest = $package_payments->first(); // first item on current page
        @endphp

        @if ($latest && $latest->approval != 1)
            {{-- not approved yet --}}
            <div class="alert alert-info">
                {{ translate('Your purchase has been created.') }}
                {{ translate('Please upload your payment') }}
                <a href="javascript:void(0)" onclick="select_payment_method_modal({{ $latest->id }})">
                    {{ translate('here') }}
                </a>
                {{ translate('for') }}
                <strong>{{ $latest->seller_package->name ?? translate('your package') }}</strong>
                {{ translate('or through the Options icon on your purchased package below.') }}
            </div>
        @endif
        <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{ translate('Package') }}</th>
                        <th data-breakpoints="lg">{{ translate('Amount') }}</th>
                        <th data-breakpoints="lg">{{ translate('Payment Method') }}</th>
                        <th data-breakpoints="lg">{{ translate('Status') }}</th>
                        <th data-breakpoints="lg">{{ translate('Transaction ID') }}</th>
                        <th data-breakpoints="lg">{{ translate('Date') }}</th>
                        <th data-breakpoints="lg" width="15%" class="text-right">{{ translate('Options') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($package_payments as $key => $package_payment)
                        <tr>
                            <td>{{ $key + 1 + ($package_payments->currentPage() - 1) * $package_payments->perPage() }}</td>
                            <td>{{ $package_payment->seller_package->name ?? translate('Deleted package') }}</td>
                            <td>{{ format_price($package_payment->amount) }}</td>
                            <td>{{ $package_payment->payment_method }}</td>
                            <td>
                                @if ($package_payment->approval == 1)
                                    <span class="badge badge-inline badge-success">{{ translate('Approved') }}</span>
                                @elseif ($package_payment->approval == 3)
                                    <span class="badge badge-inline badge-info">{{ translate('Proof Uploaded') }}</span>
                                @else
                                    <span class="badge badge-inline badge-danger">{{ translate('For Upload') }}</span>
                                @endif
                            </td>
                            <td>{{ $package_payment->payment_proof_tran_id }}</td>
                            <td>{{ $package_payment->created_at }}</td>
                            <td class="text-right">
                                @if ($package_payment->approval != 1 && $package_payment->approval != 3)
                                    <a href="javascript:void(0);" class="btn btn-soft-primary btn-icon btn-circle btn-sm"
                                        onclick="select_payment_method_modal({{ $package_payment->id }})"
                                        title="{{ translate('Upload Payment Proof') }}">
                                        <i class="las la-eye"></i>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination">
                {{ $package_payments->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
@endsection

@section('modal')
    <!-- package payment modal -->
    <div class="modal fade" id="package_payment_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-md modal-dialog-centered" role="document">
            <div class="modal-content" id="seller-package-payment-modal-content">

            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        function select_payment_method_modal(id) {
            $.post('{{ route('seller.package.package_payment_modal') }}', {
                _token: '{{ @csrf_token() }}',
                id: id
            }, function(data) {
                $('#seller-package-payment-modal-content').html(data);
                $('#package_payment_modal').modal('show', {
                    backdrop: 'static'
                });
            });
        }
    </script>
@endsection
