@extends('addon:multivendor::seller.layouts.app')

@section('content')
    <div class="aiz-titlebar mt-2 mb-4">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="h3">{{ translate('Resellers') }}</h1>
            </div>
        </div>
    </div>
    <div class="card">
        <form action="{{ route('seller.resellers') }}" method="GET">
            <div class="card-header row gutters-5">
                <div class="col text-center text-md-left">
                    <h5 class="mb-md-0 h6">{{ translate('All Resellers') }}</h5>
                </div>
                <div class="col-md-3">
                    <div class="form-group mb-0">
                        <input type="text" class="form-control form-control-sm aiz-date-range" id="search"
                            name="date_range"@isset($date_range) value="{{ $date_range }}" @endisset
                            placeholder="{{ translate('Daterange') }}" autocomplete="off">
                    </div>
                </div>
                <div class="col-auto">
                    <button type="submit" class="btn btn-sm btn-primary">{{ translate('Filter') }}</button>
                </div>
            </div>
        </form>
        <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th data-breakpoints="lg">{{ translate('Seller') }}</th>
                        <th>{{ translate('Your Earning') }}</th>
                        <th>{{ 'Seller Type' }}</th>
                        <th data-breakpoints="lg">{{ translate('Calculated At') }}</th>
                    </tr>
                </thead>
                <tbody>
                    {{-- @foreach ($referrals as $key => $referral)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $referral->name }}</td>
                            <td></td>
                            <td>{{ $referral->user_type }}</td>
                            <td>{{ $referral->created_at }}</td>
                        </tr>
                    @endforeach --}}
                </tbody>
            </table>
            <div class="aiz-pagination mt-4">
                {{-- {{ $referrals->links() }} --}}
            </div>
        </div>
    </div>
@endsection
