<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use CoreComponentRepository;

class LoginController extends Controller
{
  use AuthenticatesUsers;

  protected function authenticated(Request $request, $user)
  {
    // If user originally requested a protected page, honor it.
    if ($intended = session()->pull('url.intended')) {
      return redirect()->to($intended);
    }

    // Admin / Staff
    if (in_array($user->user_type, ['admin', 'staff'], true)) {
      CoreComponentRepository::instantiateShopRepository();
      return redirect()->route('admin.dashboard');
    }

    // Seller flow (kept as-is)
    if ($user->user_type === 'seller') {
      if ((int) $user->approval === 0) {
        $payment = $user->sellerPackagePayment()->with('seller_package')->first();

        $package = optional($payment)->seller_package
          ?? optional($user->package)
          ?? \App\Models\SellerPackage::find($user->package_id);

        $level = (int) ($package->geographic_level ?? 0);

        if ($level === 0) {
          return redirect()
            ->route('thank-you-for-registration')
            ->with('status', 'Your account is pending approval.');
        }

        return redirect()->route('seller.new_seller_payment_upload');
      }

      return redirect()->route('seller.dashboard');
    }

    if ($user->user_type === 'merchant') {
      // Optionally ensure they have permission (if you want a hard gate):
      // abort_unless($user->can('merchant.access'), 403);
      return redirect()->route('merchant.dashboard');
    }

    // Fallback
    return redirect('/');
  }

  protected function sendFailedLoginResponse(Request $request)
  {
    flash(translate('Invalid email or password'))->error();
    return back();
  }

  public function logout(Request $request)
  {
    $this->guard()->logout();
    $request->session()->invalidate();
    return $this->loggedOut($request) ?: redirect()->route('login');
  }
}
