<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Barangay;
use App\Models\City;
use App\Models\State;

class BarangayController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $sort_barangay = $request->sort_barangay;
        $sort_city = $request->sort_city;
        $barangays_queries = Barangay::query();
        if ($request->sort_barangay) {
            $barangays_queries->where('name', 'like', "%$sort_barangay%");
        }
        if ($request->sort_city) {
            $barangays_queries->where('city_id', $request->sort_city);
        }
        $barangays = $barangays_queries->orderBy('status', 'desc')->paginate(15);
        $cities = City::where('status', 1)->get();

        return view('backend.settings.barangays.index', compact('barangays', 'cities', 'sort_barangay'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $cities = City::where('status', 1)->get();
        return view('backend.settings.barangays.create', compact('cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $barangay = new Barangay;

        $barangay->name = $request->name;
        $barangay->city_id = $request->cities;

        $barangay->save();

        flash(translate('Barangay has been inserted successfully'))->success();

        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $city = City::findOrFail($id);
        $states = State::where('status', 1)->get();
        return view('backend.settings.cities.edit', compact('city', 'states'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $city = City::findOrFail($id);
        $city->name = $request->name;
        $city->state_id = $request->state_id;

        $city->save();

        flash(translate('City has been updated successfully'))->success();
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        City::destroy($id);

        flash(translate('City has been deleted successfully'))->success();
        return back();
    }

    public function updateStatus(Request $request)
    {
        $barangay = City::findOrFail($request->id);
        $barangay->status = $request->status;
        if ($barangay->save()) {
            return 1;
        }
        return 0;
    }

    public function validateCity($stateCode, $cityName)
    {
        $state = State::where('state_code', $stateCode)->first();

        if (!$state) {
            return response()->json(['valid' => false]);
        }

        $city = City::where('name', $cityName)
            ->where('state_id', $state->id)
            ->first();

        if ($city) {
            return response()->json(['valid' => true]);
        } else {
            return response()->json(['valid' => false]);
        }

    }

    public function get_barangays($cityId)
    {
        // Fetch barangays based on the selected city
        $barangays = Barangay::where('city_id', $cityId)->get();
        return response()->json(['barangays' => $barangays]);
    }
}
