<?php

namespace App\Http\Controllers;

use App\Models\Region;
use App\Models\Country;
use Illuminate\Http\Request;


class RegionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // $sort_country = $request->sort_country;
        $sort_region = $request->sort_region;

        $region_queries = Region::query();
        if ($request->sort_region) {
            $region_queries->where('name', 'like', "%$sort_region%");
        }
        // if ($request->sort_country) {
        //     $state_queries->where('country_id', $request->sort_country);
        // }

        $regions = $region_queries->paginate(15);
        return view('backend.settings.regions.index', compact('regions', 'sort_region'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $region = new Region;

        $region->name = $request->name;
        //$state->country_id = $request->country_id;

        $region->save();

        flash(translate('Region has been inserted successfully'))->success();
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $region = Region::findOrFail($id);
        //$countries = Country::where('status', 1)->get();

        return view('backend.settings.regions.edit', compact('state'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $region = Region::findOrFail($id);

        $region->name = $request->name;
        //$state->country_id = $request->country_id;

        $region->save();

        flash(translate('Region has been updated successfully'))->success();
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function updateStatus(Request $request)
    {
        $region = Region::findOrFail($request->id);
        $region->status = $request->status;
        $region->save();

        // foreach ($state->cities as $city) {
        //     $city->status = $request->status;
        //     $city->save();
        // }

        return 1;
    }
}
