<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\SellerPackage;
use App\Models\SellerPackagePayment;

class SellerPackagePaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function offline_payment_request()
    {
        $package_payment_requests = SellerPackagePayment::where('offline_payment', 1)->orderBy('id', 'desc')->paginate(10);
        return view('backend.manual_payment_methods.seller_package_payment_request', compact('package_payment_requests'));
    }

    public function offline_payment_approval($id)
    {
        $package_payment = SellerPackagePayment::findOrFail($id);
        $package_details = SellerPackage::findOrFail($package_payment->seller_package_id);
        $package_payment->approval = 1;
        if ($package_payment->save()) {
            $seller = $package_payment->user->shop;
            $seller->seller_package_id = $package_payment->seller_package_id;
            $seller->product_upload_limit = $package_details->product_upload_limit;
            $seller->commission = $package_details->commission;
            $seller->package_invalid_at = date('Y-m-d', strtotime($seller->package_invalid_at . ' +' . $package_details->duration . 'days'));
            if ($seller->save()) {
                flash(translate('Offline Seller Package Payment approved successfully.'))->success();
                return back();
            }
        }
        flash(translate('Something went wrong'))->error();
        return back();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        \Log::info($request->all());

        $package_payment = new SellerPackagePayment;
        $package_payment->user_id = $request->member_id;
        $package_payment->seller_package_id = $request->package_id;

        $sellerPackage = SellerPackage::findOrFail($package_payment->seller_package_id);
        $package_payment->amount = $sellerPackage->amount;
        $package_payment->approval = 2;
        $package_payment->payment_method = $request->payment_method;

        // Check if proof_upload is present in the request before assigning it, THIS IS FOR WP UPLOAD
        if ($request->has('proof_upload')) {
            $package_payment->payment_proof_upload_wp = $request->proof_upload;
        }

        $package_payment->save();

        // Generate transaction ID based on the format "id-user_id-seller_package_id-transaction_id"
        $transactionId = $package_payment->id . $request->member_id . $request->package_id . Str::random(4);
        $package_payment->payment_proof_tran_id = $transactionId;

        // Update the package payment with the generated transaction ID
        $package_payment->update();

        // $admin = User::where('user_type', 'admin')->first();
        // Notification::send($admin, new SellerRegistrationDbNotification($user));
        // try {
        //     $admin->notify(new SellerRegistrationNotification($package_payment));
        // } catch (\Exception $e) {
        // }

        //Notify the newly registered user
        //$user->notify(new SellerReferralRegistrationNotification($shop));

        return response()->json([
            'success' => true,
            'message' => translate('Thanks for payment!'),
        ]);
    }
    public function check_tran_exists(Request $request)
    {
        $transaction = $request->input('payment_proof_tran_id');

        $sellerpackage = SellerPackagePayment::where('payment_proof_tran_id', $transaction)->first();

        if ($sellerpackage !== null) {
            return response()->json([
                'exists' => true,
            ]);
        } else {
            return response()->json([
                'exists' => false,
            ]);
        }
    }

    public function check_wp_tran_exists($transactionNo)
    {
        // Check if the transaction number exists in the database
        $sellerPackagePayment = SellerPackagePayment::where('payment_proof_tran_id', $transactionNo)->first();

        // Return JSON response based on whether the transaction exists or not
        if ($sellerPackagePayment) {
            return response()->json([
                'exists' => true,
            ]);
        } else {
            return response()->json([
                'exists' => false,
            ]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
