<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureUserApproved
{
  public function handle(Request $request, Closure $next)
  {
    $user = $request->user();
    if (!$user) {
      return redirect()->route('login');
    }

    // Only gate sellers
    if ($user->user_type === 'seller' && (int) $user->approval === 0) {
      // Allow the upload page itself (and its POST) to pass
      if (
        $request->routeIs('seller.new_seller_payment_upload') ||
        $request->is('payment-upload') || $request->is('seller.payment-upload/*')
      ) {
        return $next($request);
      }

      return redirect()
        ->route('seller.new_seller_payment_upload')
        ->with('status', 'Your account is pending approval.');
    }

    return $next($request);
  }
}
