<?php

namespace App\Http\Middleware;

use Closure;
use Auth;

class IsSeller
{
  public function handle($request, \Closure $next)
  {
    $user = auth()->user();

    if (!$user || $user->user_type !== 'seller') {
      return redirect()->route('login');
    }

    // Resolve payment + package + level
    $payment = $user->sellerPackagePayment()->with('seller_package')->first();
    $package = optional($payment)->seller_package
      ?? optional($user->package)
      ?? \App\Models\SellerPackage::find($user->package_id);

    $level = (int) ($package->geographic_level ?? 0);

    // Current route name & the upload-only routes
    $currentRoute = optional($request->route())->getName();
    $uploadRoutes = [
      'seller.new_seller_payment_upload',
      'seller.payment_upload_modal',
      'seller.new_seller_payment_upload_proof',
    ];

    // If seller is not approved yet
    if ((int) $user->approval === 0) {
      // No-payment packages → always bounce to login with message
      if ($level === 0) {
        return redirect()
          ->route('login')
          ->with('status', 'Your account is pending approval.');
      }

      // Payment packages (level > 0)
      if ($payment && (int) $payment->approval === 1) {
        // Payment already approved, but account not yet approved by admin
        return redirect()
          ->route('login')
          ->with('status', 'Your payment is approved. Your account is pending admin approval.');
      }

      // Payment not approved yet → allow ONLY upload routes
      if (!in_array($currentRoute, $uploadRoutes, true)) {
        return redirect()->route('seller.new_seller_payment_upload');
      }

      // On an allowed upload route → continue
      return $next($request);
    }

    // Approved seller → continue normally
    return $next($request);
  }
}
