<?php

namespace App\Http\Resources;

use App\Models\ProductVariationCombination;
use Illuminate\Http\Resources\Json\ResourceCollection;

class PosProductCollection extends ResourceCollection
{
    public function toArray($request)
    {
        return [
            'data' => $this->collection->map(function ($data) {
                return [
                    'id' => $data->id,
                    'name' => $data->name,
                    'thumbnail_image' => ($data->thumbnail_img != null) ? uploaded_asset($data->thumbnail_img) : uploaded_asset($data->stock_image),
                    'qty' => $data->stock,
                    'price' => single_price($data->lowest_price),
                ];
            })
        ];
    }


    public function with($request)
    {
        return [
            'success' => true,
            'status' => 200
        ];
    }
}
