<?php

namespace App\Jobs;

use App\Models\Order;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Notification;
use App\Notifications\PaidNotificationAdmin;
use App\Notifications\PaidNotificationCustomer;

class SendOrderNotifications implements ShouldQueue
{
  use InteractsWithQueue, Queueable, SerializesModels;

  public $order;

  public function __construct(Order $order)
  {
    $this->order = $order;
  }

  public function handle()
  {
    $order = $this->order;

    // Admin
    $admin = User::where('user_type', 'admin')->first();
    if ($admin) {
      $admin->notify(new PaidNotificationAdmin($order));
    }

    // Reseller
    $user = User::find($order->user_id);
    if ($user && $user->email) {
      Notification::route('mail', $user->email)
        ->notify(new PaidNotificationCustomer($order));
    }

    // Customer
    if ($order->email) {
      Notification::route('mail', $order->email)
        ->notify(new PaidNotificationCustomer($order));
    }
  }
}
