<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CommissionHistory extends Model
{
  protected $fillable = [
    'order_id',
    'user_id',
    'seller_earning',
    'details',
  ];

  protected $appends = ['source_label'];

  public function getSourceLabelAttribute(): string
  {
    $type = $this->source_type;

    if (!$type) {
      if (!is_null($this->order_id)) return translate('Customer Order');
      return match (trim((string)$this->details)) {
        'Package Payment.'            => translate('Affiliate Registration'),
        'Referral Sale Commission.'   => translate('Affiliate Sale'),
        'Area Sale Bonus.'            => translate('Area Sale Bonus Commission'),
        default                       => translate('Other'),
      };
    }

    return match ($type) {
      'order_sale' || 'order_sale_helper'         => translate('Customer Order'),
      'registration'  => translate('Affiliate Registration'),
      'referral_sale' => translate('Affiliate Sale'),
      'area_bonus'    => translate('Area Sale Bonus Commission'),
      default         => translate('Other'),
    };
  }

  public function order()
  {
    return $this->belongsTo(Order::class);
  }

  public function user()
  {
    return $this->belongsTo(User::class, 'user_id');
  }
}
