<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Passport\HasApiTokens;
use App\Models\Cart;
use App\Models\Wishlist;
use App\Models\Product;
use App\Models\Order;
use App\Models\Wallet;
use App\Models\Review;
use App\Models\Address;
use App\Models\SellerPackagePayment;
use App\Models\CommissionHistory;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable implements MustVerifyEmail
{
  use Notifiable, HasApiTokens, HasRoles;

  /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = [
    'name',
    'email',
    'password',
    'phone',
    'avatar',
    'provider_id',
    'email_verified_at',
    'verification_code',
    'referral_code'
  ];

  /**
   * The attributes that should be hidden for arrays.
   *
   * @var array
   */
  protected $hidden = [
    'password',
    'remember_token',
  ];

  public function wishlists()
  {
    return $this->hasMany(Wishlist::class);
  }

  public function role()
  {
    return $this->belongsTo(Role::class);
  }

  public function orders()
  {
    return $this->hasMany(Order::class, 'user_id');
  }

  public function wallets()
  {
    return $this->hasMany(Wallet::class)->orderBy('created_at', 'desc');
  }

  public function carts()
  {
    return $this->hasMany(Cart::class);
  }

  public function reviews()
  {
    return $this->hasMany(Review::class);
  }

  public function addresses()
  {
    return $this->hasMany(Address::class);
  }

  public function chat_thread()
  {
    return $this->hasOne(ChatThread::class);
  }

  public function conversations()
  {
    return $this->hasMany(Conversation::class, 'sender_id', 'id');
  }

  public function affiliate_user()
  {
    return $this->hasOne(AffiliateUser::class);
  }
  public function affiliate_withdraw_request()
  {
    return $this->hasMany(AffiliateWithdrawRequest::class);
  }
  public function affiliate_log()
  {
    return $this->hasMany(AffiliateLog::class);
  }
  public function seller_package()
  {
    return $this->belongsTo(SellerPackage::class, 'package_id');
  }
  public function sellerPackagePayment()
  {
    return $this->hasOne(SellerPackagePayment::class, 'user_id')->with('seller_package');
  }

  public function sellerPackagePayments()
  {
    return $this->hasMany(SellerPackagePayment::class, 'user_id');
  }

  public function commission_histories()
  {
    return $this->hasMany(CommissionHistory::class, 'user_id', 'referred_by')
      ->where('details', 'Package Payment.');
  }
  public function locationAssignments()
  {
    return $this->hasMany(\App\Models\UserLocationAssignment::class);
  }

  public function products()
  {
    return $this->hasMany(Product::class, 'user_id', 'id');
  }

  public function package()
  {
    return $this->belongsTo(SellerPackage::class, 'package_id');
  }
}
