<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PaidNotificationCustomer extends Notification
{
    use Queueable;
    public $order;

    /**
     * Create a new notification instance.
     *
     * @param  \App\Models\Order  $order
     * @return void
     */
    public function __construct($order)
    {
        $this->order = $order;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Thank you for Your Payment')
            ->greeting('Hello ' . $this->order->name . '!')
            ->line('We have successfully received and validated your payment.')
            ->line('Order Code: ' . $this->order->combined_order->code)
            ->line('Sub Total: ' . format_price($this->order->orderDetails->sum('total')))
            ->line('Shipping: ' . format_price($this->order->shipping_cost))
            ->line('Total: ' . format_price($this->order->orderDetails->sum('total') + $this->order->shipping_cost))
            ->line('Your payment ensures that your order is now being processed.')
            ->line('Thank you for choosing our service!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'order_id' => $this->order->id,
            'payment_status' => $this->order->payment_status,
        ];
    }
}
