<?php

namespace App\Notifications;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
// If you actually want to queue it, uncomment the next line and implement it.
// use Illuminate\Contracts\Queue\ShouldQueue;

class SellerUploadPaymentNotification extends Notification // implements ShouldQueue
{
  use Queueable;

  /** @var \App\Models\User */
  public $user;

  public function __construct(User $user)
  {
    $this->user = $user;
  }

  public function via($notifiable)
  {
    return ['mail'];
  }

  public function toMail($notifiable)
  {
    $url = route('admin.package_purchase_history');

    return (new MailMessage)
      ->greeting('Hello!')
      ->line(($this->user->name ?? 'A user') . ' has uploaded a payment proof. Click the button below to review.')
      ->action('Package Payment Lists', $url);
  }

  public function toArray($notifiable)
  {
    return [
      'user_id' => $this->user->id,
      'name'    => $this->user->name,
      'email'   => $this->user->email,
    ];
  }
}
