<?php

namespace App\Services;

final class Phone
{
  public static function normalizePhMobile(?string $raw): ?string
  {
    if ($raw === null) return null;
    $n = preg_replace('/\D+/', '', $raw);
    if ($n === '') return null;

    if (str_starts_with($n, '63')) {
      $n = '0' . substr($n, 2);
    }
    if (strlen($n) === 10 && $n[0] === '9') {
      $n = '0' . $n;
    }
    if (!preg_match('/^09\d{9}$/', $n)) {
      return null;
    }
    return $n;
  }
}
