<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class WooCommerceService
{
  protected $url;
  protected $key;
  protected $secret;

  public function __construct()
  {
    $this->url = rtrim(config('services.woocommerce.url'), '/');
    $this->key = config('services.woocommerce.key');
    $this->secret = config('services.woocommerce.secret');
  }

  // CREATE product on WooCommerce
  public function createProduct(array $data)
  {
    return Http::withBasicAuth($this->key, $this->secret)
      ->post("{$this->url}/wp-json/wc/v3/products", $data)
      ->json();
  }

  // UPDATE product on WooCommerce
  public function updateProduct($wcProductId, array $data)
  {
    return Http::withBasicAuth($this->key, $this->secret)
      ->put("{$this->url}/wp-json/wc/v3/products/{$wcProductId}", $data)
      ->json();
  }

  // DELETE product on WooCommerce
  public function deleteProduct($wcProductId)
  {
    return Http::withBasicAuth($this->key, $this->secret)
      ->delete("{$this->url}/wp-json/wc/v3/products/{$wcProductId}?force=true")
      ->json();
  }
}
