@extends('backend.layouts.app')

@section('content')
    <div class="row">
        <div class="col-xl-3 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5" style="background:#91A8D0">
                <div class="pb-4">
                    <div class="fw-500">{{ translate('Orders') }}</div>
                    <div class="h2 fw-700">{{ $totalOrders }}</div>
                </div>
            </div>
        </div>

        <div class="col-xl-9 col-md-6">
            <div class="shadow-xl rounded-lg pt-5 px-4 mb-5" style="background:#F0C05A">
                <div class="row">
                    <div class="col-6 col-sm-4 col-xl-2 mb-4">
                        <div class="fw-500">{{ translate('Order Placed') }}</div>
                        <div class="h2 fw-700">{{ $countPlaced }}</div>
                    </div>
                    <div class="col-6 col-sm-4 col-xl-2 mb-4">
                        <div class="fw-500">{{ translate('Order Packed') }}</div>
                        <div class="h2 fw-700">{{ $countPacked }}</div>
                    </div>
                    <div class="col-6 col-sm-4 col-xl-2 mb-4">
                        <div class="fw-500">{{ translate('Shipped To Courier') }}</div>
                        <div class="h2 fw-700">{{ $countShipped }}</div>
                    </div>
                    <div class="col-6 col-sm-4 col-xl-2 mb-4">
                        <div class="fw-500">{{ translate('In Transit') }}</div>
                        <div class="h2 fw-700">{{ $countInTransit }}</div>
                    </div>
                    <div class="col-6 col-sm-4 col-xl-2 mb-4">
                        <div class="fw-500">{{ translate('Out for Delivery') }}</div>
                        <div class="h2 fw-700">{{ $countOutForDelivery }}</div>
                    </div>
                    <div class="col-6 col-sm-4 col-xl-2 mb-4">
                        <div class="fw-500">{{ translate('Order Delivered') }}</div>
                        <div class="h2 fw-700">{{ $countDelivered }}</div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="d-flex justify-content-between align-items-center mb-3">
        <div class="fs-16 fw-700">{{ translate('Top Products') }}</div>
    </div>

    <div class="row">
        @forelse($topProducts as $product)
            <div class="col-sm-6 col-md-4 col-xl-3 mb-3">
                <div class="aiz-card-box border rounded bg-white p-3 h-100">
                    <a href="/product/{{ $product->slug }}" target="_blank" class="d-block mb-2">
                        <img class="img-fit h-160px w-100" src="{{ uploaded_asset($product->thumbnail_img) }}"
                            onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                    </a>
                    <div class="fw-600 text-truncate mb-1">{{ $product->name }}</div>
                    <div class="small opacity-70">{{ translate('Sold') }}: {{ $product->num_of_sale }}</div>
                </div>
            </div>
        @empty
            <div class="col-12 text-muted">{{ translate('No products yet.') }}</div>
        @endforelse
    </div>
@endsection
