@extends('backend.layouts.app')

@section('content')
    <h1 class="h4 fw-700 mb-3">
        {{ translate("Seller's Order") }}: {{ optional($order->user)->name }} <br>
        {{ translate('Order code') }}: {{ optional($order->combined_order)->code }}
    </h1>

    @if (is_null($order->shipping_cost))
        <div class="alert alert-danger d-flex align-items-center">
            {{ translate('No Shipping Cost has set yet.') }}
        </div>
    @endif

    <div class="row gutters-5">
        <div class="col-lg">
            <div class="card">
                <div class="card-header">
                    <h2 class="h2 fs-16 fw-600 mb-0">{{ translate('Order Details') }}</h2>
                </div>

                {{-- Top info --}}
                <div class="card-header">
                    <div class="flex-grow-1 row">
                        <div class="col-md mb-3">
                            <div>
                                <div class="fs-15 fw-600 mb-2">{{ translate('Customer info') }}</div>
                                <div><span class="opacity-80 mr-2 ml-0">{{ translate('Name') }}:</span>
                                    {{ $order->name ?? '' }}</div>
                                <div><span class="opacity-80 mr-2 ml-0">{{ translate('Email') }}:</span>
                                    {{ $order->email ?? '' }}</div>
                                <div><span class="opacity-80 mr-2 ml-0">{{ translate('Phone') }}:</span>
                                    {{ $order->phone ?? '' }}</div>
                            </div>
                        </div>
                        <div class="col-md-6 col-xl-4">
                            <table class="table table-borderless table-sm">
                                <tbody>
                                    <tr>
                                        <td>{{ translate('Order code') }}:</td>
                                        <td class="text-right text-info fw-700">
                                            {{ optional($order->combined_order)->code }}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ translate('Order Date') }}:</td>
                                        <td class="text-right fw-700">{{ $order->created_at->format('d.m.Y') }}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ translate('Delivery type') }}:</td>
                                        <td class="text-right fw-700">
                                            {{ ucfirst(str_replace('_', ' ', $order->delivery_type ?? '')) }}</td>
                                    </tr>
                                    <tr>
                                        <td>{{ translate('Payment method') }}:</td>
                                        <td class="text-right fw-700">
                                            {{ ucfirst(str_replace('_', ' ', $order->payment_type ?? '')) }}</td>
                                    </tr>

                                    @if ($order->manual_payment == 1 && !empty($order->manual_payment_data))
                                        @php $manual_payment_data = json_decode($order->manual_payment_data, true) ?: []; @endphp
                                        @if ($manual_payment_data)
                                            <tr>
                                                <td>{{ translate('Transaction ID') }}:</td>
                                                <td class="text-right fw-700">
                                                    {{ $manual_payment_data['transactionId'] ?? '' }}</td>
                                            </tr>
                                            <tr>
                                                <td>{{ translate('Paid Via') }}:</td>
                                                <td class="text-right fw-700">
                                                    {{ $manual_payment_data['payment_method'] ?? '' }}</td>
                                            </tr>
                                            @if (!empty($manual_payment_data['reciept']))
                                                <tr>
                                                    <td>{{ translate('Receipt') }}:</td>
                                                    <td class="text-right fw-700">
                                                        <a href="{{ my_asset($manual_payment_data['reciept']) }}"
                                                            target="_blank" rel="noopener noreferrer">
                                                            {{ translate('Download') }}
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endif
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                {{-- Status + Ship-To/Billing --}}
                <div class="card-header">
                    <div class="flex-grow-1 row align-items-start">
                        <div class="col-md-3 mr-auto ml-0">
                            <div class="mb-3">
                                <label class="mb-0">{{ translate('Payment Status') }}</label>
                                <select class="form-control aiz-selectpicker" id="update_payment_status"
                                    data-minimum-results-for-search="Infinity" data-selected="{{ $order->payment_status }}"
                                    @if ($order->payment_status == 'paid' || $order->delivery_status == 'cancelled') disabled @endif>
                                    <option value="paid">{{ translate('Paid') }}</option>
                                    <option value="unpaid">{{ translate('Unpaid') }}</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="mb-0">{{ translate('Delivery Status') }}</label>
                                <select class="form-control aiz-selectpicker" id="update_delivery_status"
                                    data-minimum-results-for-search="Infinity"
                                    data-selected="{{ $order->delivery_status }}">
                                    <option value="order packed">{{ translate('Order Packed') }}</option>
                                    <option value="shipped to courier">{{ translate('Shipped To Courier') }}</option>
                                    <option value="in transit">{{ translate('In Transit') }}</option>
                                    <option value="out for delivery">{{ translate('Out for Delivery') }}</option>
                                    <option value="delivered" @if ($order->delivery_status == 'delivered') selected @endif>
                                        {{ translate('Delivered') }}</option>
                                </select>
                            </div>
                        </div>

                        @php
                            // POS / special case: show the "Ship To" card when order->code == 1
                            $showShipTo = (string) $order->code === '1' || (int) $order->code === 1;
                            $u = optional($order->user);
                        @endphp

                        @if ($showShipTo)
                            <div class="col-md-auto w-md-250px">
                                <h5 class="fs-14 mb-3">
                                    {{ translate('Ship To') }}
                                    @if ((int) $u->ship_to_other === 1)
                                        {{ translate('Friend/Family') }}
                                    @endif
                                </h5>
                                <address class="">
                                    <div>
                                        <span class="opacity-80">{{ translate('Name') }}:</span>
                                        {{ $u->recipient_name ?? '-' }}
                                    </div>
                                    <div>
                                        <span class="opacity-80">{{ translate('Phone') }}:</span>
                                        {{ $u->recipient_phone ?? '-' }}
                                    </div>
                                    <div class="mt-1">
                                        <span class="opacity-80">{{ translate('Address') }}:</span><br>
                                        {{ $u->recipient_address ?? '-' }}
                                    </div>

                                    @if ((int) $u->ship_to_other === 1)
                                        <small class="d-block mt-2 opacity-70">
                                            {{ translate('Notifications are sent to the account email:') }}
                                            <strong>{{ $order->email }}</strong>
                                        </small>
                                    @endif
                                </address>
                            </div>
                        @else
                            {{-- Non-POS / regular: show original Shipping address --}}
                            <div class="col-md-auto w-md-250px">
                                <h5 class="fs-14 mb-3">{{ translate('Shipping address') }}</h5>
                                <address class="">{{ $order->shipping_address }}</address>
                            </div>
                        @endif

                        <div class="col-md-auto w-md-250px">
                            <h5 class="fs-14 mb-3">{{ translate('Billing address') }}</h5>
                            <address>{{ $order->billing_address }}</address>
                        </div>
                    </div>
                </div>

                {{-- Items --}}
                <div class="card-body">
                    <table class="aiz-table table-bordered">
                        <thead>
                            <tr>
                                <th class="text-center" width="5%" data-breakpoints="lg">#</th>
                                <th width="40%">{{ translate('Product') }}</th>
                                <th class="text-center" data-breakpoints="lg">{{ translate('Qty') }}</th>
                                <th class="text-center" data-breakpoints="lg">{{ translate('Unit Price') }}</th>
                                <th class="text-center" data-breakpoints="lg">{{ translate('Total') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($order->orderDetails as $key => $orderDetail)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>
                                        @if ($orderDetail->product)
                                            <div class="media">
                                                <img src="{{ uploaded_asset($orderDetail->product->thumbnail_img) }}"
                                                    class="size-60px mr-3"
                                                    onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';">
                                                <div class="media-body">
                                                    <h4 class="fs-14 fw-400">{{ $orderDetail->product->name }}</h4>
                                                    @php
                                                        $combinations = data_get(
                                                            $orderDetail,
                                                            'variation.combinations',
                                                            [],
                                                        );
                                                        if (!is_iterable($combinations)) {
                                                            if (is_string($combinations)) {
                                                                $decoded = json_decode($combinations, true);
                                                                $combinations = is_array($decoded) ? $decoded : [];
                                                            } else {
                                                                $combinations = [];
                                                            }
                                                        }
                                                    @endphp
                                                    @if (!empty($combinations))
                                                        <div>
                                                            @foreach ($combinations as $combination)
                                                                @php
                                                                    $attrName = data_get(
                                                                        $combination,
                                                                        'attribute.name',
                                                                        data_get($combination, 'attribute', ''),
                                                                    );
                                                                    $valueName = data_get(
                                                                        $combination,
                                                                        'attribute_value.name',
                                                                        data_get($combination, 'value', ''),
                                                                    );
                                                                @endphp
                                                                @if ($attrName !== '' || $valueName !== '')
                                                                    <span class="mr-2">
                                                                        <span
                                                                            class="opacity-50">{{ $attrName }}</span>:
                                                                        {{ $valueName }}
                                                                    </span>
                                                                @endif
                                                            @endforeach
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @else
                                            <strong>{{ translate('Product Unavailable') }}</strong>
                                        @endif
                                    </td>
                                    <td class="text-center">{{ $orderDetail->quantity }}</td>
                                    <td class="text-center">{{ format_price($orderDetail->price) }}</td>
                                    <td class="text-center">{{ format_price($orderDetail->total) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                    {{-- Totals --}}
                    <div class="row">
                        <div class="col-xl-4 col-md-6 ml-auto mr-0">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td><strong>{{ translate('Sub Total') }} :</strong></td>
                                        <td>{{ format_price($order->orderDetails->sum('total')) }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ translate('Discount') }} :</strong></td>
                                        <td>
                                            - {{ $discount }}%
                                            @php
                                                $originalAmount = $order->orderDetails->sum('total');
                                                $discountAmount = ($discount / 100) * $originalAmount;
                                            @endphp
                                            ({{ format_price($discountAmount) }})
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ translate('Shipping') }} :</strong></td>
                                        <td>
                                            <div class="ml-0">
                                                <form action="{{ route('orders.add_shipping_cost') }}" method="POST">
                                                    @csrf
                                                    <div class="input-group">
                                                        <input type="hidden" name="order_id" value="{{ $order->id }}">
                                                        <input class="mr-2 form-control" type="number" min="0"
                                                            step="0.01" placeholder="Amount" name="shipping_cost_set"
                                                            value="{{ $order->shipping_cost }}" required>
                                                        <button class="btn btn-sm btn-primary" type="submit"
                                                            @if ($order->payment_status == 'paid' || $order->delivery_status == 'cancelled') disabled @endif>
                                                            {{ translate('Save') }}
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ translate('TOTAL') }} :</strong></td>
                                        <td class="h4">
                                            @php
                                                $totalPrice = $order->orderDetails->sum('total');
                                                $discountedTotal =
                                                    $totalPrice -
                                                    $totalPrice * ($discount / 100) +
                                                    ($order->shipping_cost ?? 0);
                                            @endphp
                                            {{ format_price($discountedTotal) }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{-- Right column --}}
        <div class="col col-lg-auto w-lg-300px">
            <div class="card">
                <div class="card-header">
                    <h3 class="fs-16 mb-0">{{ translate('Tracking information') }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('orders.add_tracking_information') }}" method="POST">
                        @csrf
                        <input type="hidden" name="order_id" value="{{ $order->id }}">
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Courier name') }}:</label>
                            <input type="text" class="form-control form-control-sm" name="courier_name"
                                value="{{ $order->courier_name }}" required>
                        </div>
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Tracking number') }}:</label>
                            <input type="text" class="form-control form-control-sm" name="tracking_number"
                                value="{{ $order->tracking_number }}" required>
                        </div>
                        <div class="form-group mb-1">
                            <label class="mb-0">{{ translate('Tracking url') }}:</label>
                            <input type="text" class="form-control form-control-sm" name="tracking_url"
                                value="{{ $order->tracking_url }}" required>
                        </div>
                        <div class="text-right">
                            <button class="btn btn-sm btn-primary" type="submit">{{ translate('Save') }}</button>
                        </div>
                    </form>
                </div>
            </div>

            {{-- Order updates --}}
            <div class="card">
                <div class="card-header">
                    <h3 class="fs-16 mb-0">{{ translate('Order updates') }}</h3>
                </div>
                <div class="card-body">
                    @php
                        $updates = $order->order_udpates ?? collect();
                        if (is_null($updates)) {
                            $updates = collect();
                        }
                        if (is_array($updates)) {
                            $updates = collect($updates);
                        }
                    @endphp

                    @forelse ($updates as $order_udpate)
                        <div class="mb-3">
                            <div class="p-2 bg-soft-secondary rounded">
                                {{ $order_udpate->translatable_note ?? false ? translate($order_udpate->note) : $order_udpate->note ?? '' }}
                            </div>
                            <span class="fs-12 opacity-60">
                                {{ translate('by') . ' ' . (optional($order_udpate->user)->name ?? translate('Deleted user')) . ' at ' . optional($order_udpate->created_at)->format('h:ia, d-m-Y') }}
                            </span>
                        </div>
                    @empty
                        <div class="text-muted">{{ translate('No updates yet.') }}</div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        $('#update_delivery_status').on('change', function() {
            var order_id = {{ $order->id }};
            var status = $('#update_delivery_status').val();
            $.post('{{ route('orders.update_delivery_status') }}', {
                _token: '{{ @csrf_token() }}',
                order_id: order_id,
                status: status
            }, function() {
                window.location.reload();
            });
        });

        $('#update_payment_status').on('change', function() {
            var order_id = {{ $order->id }};
            var status = $('#update_payment_status').val();
            $.post('{{ route('orders.update_payment_status') }}', {
                _token: '{{ @csrf_token() }}',
                order_id: order_id,
                status: status
            }, function() {
                window.location.reload();
            });
        });
    </script>
@endsection
