@php
    // Ensure $cart is an array we can iterate, no matter what arrives from the controller
    if ($cart instanceof \Illuminate\Support\Collection) {
        $cart = $cart->all();
    } elseif (!is_array($cart)) {
        $cart = (array) $cart;
    }

    // Guard numeric values
    $subtotal = isset($subtotal) ? (float) $subtotal : 0.0;
    $discount = isset($discount) ? (float) $discount : 0.0;
    $total = isset($total) ? (float) $total : max(0, $subtotal - ($subtotal * $discount) / 100);
@endphp

<div class="row">
    {{-- Left: Cart items --}}
    <div class="col-xl-6">
        @if (!empty($cart) && is_iterable($cart))
            <ul class="list-group list-group-flush">
                @foreach ($cart ?? [] as $row)
                    @php
                        $name = $row['name'] ?? translate('Unknown product');
                        $thumb_id = $row['thumb_id'] ?? null;
                        $price = (float) ($row['price'] ?? 0);
                        $qty = (int) ($row['quantity'] ?? 0);
                    @endphp
                    <li class="list-group-item px-0">
                        <div class="row gutters-10 align-items-center">
                            <div class="col">
                                <div class="d-flex">
                                    <img src="{{ $thumb_id ? uploaded_asset($thumb_id) : static_asset('/assets/img/placeholder.jpg') }}"
                                        class="img-fit size-60px"
                                        onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';">
                                    <span class="flex-grow-1 ml-3 mr-0">
                                        <div class="text-truncate-2">{{ $name }}</div>
                                    </span>
                                </div>
                            </div>
                            <div class="col-xl-3">
                                <div class="fs-14 fw-600 text-right">{{ single_price($price) }}</div>
                                <div class="fs-14 text-right">{{ translate('QTY') }}: {{ $qty }}</div>
                            </div>
                        </div>
                    </li>
                @endforeach
            </ul>
        @else
            <div class="text-center">
                <i class="las la-frown la-3x opacity-50"></i>
                <p>{{ translate('No Product Added') }}</p>
            </div>
        @endif
    </div>

    {{-- Right: Ship-to and totals --}}
    <div class="col-xl-6">
        <div class="pl-xl-4">
            {{-- Ship-to card --}}
            <div class="card mb-4">
                <div class="card-header d-flex align-items-center">
                    <span class="fs-16">{{ translate('Shipping To') }}</span>
                    @if (!empty($shipToOther))
                        <span class="badge badge-inline badge-info ml-2">{{ translate('Friend/Family') }}</span>
                    @else
                        <span class="badge badge-inline badge-secondary ml-2">{{ translate('Yourself') }}</span>
                    @endif
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>{{ translate('Name') }}:</span>
                        <span class="fw-600">{{ $shippingName ?? '-' }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>{{ translate('Email') }}:</span>
                        <span class="fw-600">{{ $shippingEmail ?? '-' }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>{{ translate('Phone') }}:</span>
                        <span class="fw-600">{{ $shippingPhone ?? '-' }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>{{ translate('Address') }}:</span>
                        <span class="fw-600 text-right" style="max-width: 65%;">{{ $shippingAddress ?? '-' }}</span>
                    </div>
                </div>
            </div>

            {{-- Totals --}}
            <div class="d-flex justify-content-between fw-600 mb-2 opacity-70">
                <span>{{ translate('Sub Total') }}</span>
                <span>{{ single_price($subtotal) }}</span>
            </div>

            <div class="d-flex justify-content-between fw-600 mb-2 opacity-70">
                <span>{{ translate('Discount') }}</span>
                <span>{{ (float) $discount }}%</span>
            </div>

            <div class="d-flex justify-content-between fw-600 fs-18 border-top pt-2">
                <span>{{ translate('Total') }}</span>
                <span>{{ single_price($total) }}</span>
            </div>
        </div>
    </div>
</div>
