@extends('backend.layouts.app')

@section('content')
    <div class="row">
        <div class="col-md-7">
            <div class="card">
                <form class="" id="sort_cities" action="" method="GET">
                    <div class="card-header row gutters-5">
                        <div class="col text-center text-md-left">
                            <h5 class="mb-md-0 h6">{{ translate('Regions') }}</h5>
                        </div>
                        <div class="col-md-3">
                            <input type="text" class="form-control" id="sort_region" name="sort_region"
                                @isset($sort_region) value="{{ $sort_region }}" @endisset
                                placeholder="{{ translate('Type region name') }}">
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-primary" type="submit">{{ translate('Filter') }}</button>
                        </div>
                    </div>
                </form>
                <div class="card-body">
                    <table class="table aiz-table mb-0">
                        <thead>
                            <tr>
                                <th width="10%">#</th>
                                <th>{{ translate('Name') }}</th>
                                <th>{{ translate('Show/Hide') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($regions as $key => $region)
                                <tr>
                                    <td>{{ $key + 1 + ($regions->currentPage() - 1) * $regions->perPage() }}</td>
                                    <td>{{ $region->name }}</td>
                                    <td>
                                        <label class="aiz-switch aiz-switch-success mb-0">
                                            <input onchange="update_status(this)" value="{{ $region->id }}"
                                                type="checkbox" <?php if ($region->status == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <span class="slider round"></span>
                                        </label>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="aiz-pagination">
                        {{ $regions->appends(request()->input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        function update_status(el) {
            if (el.checked) {
                var status = 1;
            } else {
                var status = 0;
            }
            $.post('{{ route('regions.status') }}', {
                _token: '{{ csrf_token() }}',
                id: el.value,
                status: status
            }, function(data) {
                if (data == 1) {
                    AIZ.plugins.notify('success', '{{ translate('Region status updated successfully') }}');
                } else {
                    AIZ.plugins.notify('danger', '{{ translate('Something went wrong') }}');
                }
            });
        }
    </script>
@endsection
