@extends('backend.layouts.page')

@section('content')
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <div class="mt-4">
                <div class="align-items-center gutters-5 row">
                    <div class="col">
                        <div class="overflow-hidden">
                            <div class="card-body align-items-center justify-content-center">
                                <div class="form-group row">
                                    <div class="card-body">
                                        <form class="form form-horizontal mar-top" method="POST" role="form"
                                            action="{{ route('signup') }}">
                                            @csrf
                                            @if ($errors->any())
                                                <div class="alert alert-danger">
                                                    <ul class="mb-0">
                                                        @foreach ($errors->all() as $error)
                                                            <li>{{ $error }}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endif

                                            <div class="row gutters-5">
                                                <div class="col-lg">

                                                    <div class="card">
                                                        <div style="justify-content: center;" class="card-header">
                                                            <h5 class="mb-0 h6">{{ translate('Membership Registration') }}
                                                            </h5>
                                                        </div>

                                                        <input id="sellerid" type="hidden" class="form-control"
                                                            name="sellerid" value="{{ request('sellerid') }}" required>

                                                        <div class="card-body">

                                                            <div class="form-group row">
                                                                <label
                                                                    class="col-md-3 col-from-label">{{ translate('First Name') }}
                                                                    <span class="text-danger">*</span></label>
                                                                <div class="col-md-8">
                                                                    <input id="first_name" type="text"
                                                                        class="form-control @error('first_name') is-invalid @enderror"
                                                                        name="first_name"
                                                                        placeholder="{{ translate('First Name') }}"
                                                                        value="{{ old('first_name') }}" required>
                                                                    @error('first_name')
                                                                        <span class="invalid-feedback" role="alert">
                                                                            <strong>{{ $message }}</strong>
                                                                        </span>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label
                                                                    class="col-md-3 col-from-label">{{ translate('Last Name') }}
                                                                    <span class="text-danger">*</span></label>
                                                                <div class="col-md-8">
                                                                    <input id="last_name" type="text"
                                                                        class="form-control @error('last_name') is-invalid @enderror"
                                                                        name="last_name"
                                                                        placeholder="{{ translate('Last Name') }}"
                                                                        value="{{ old('last_name') }}" required>
                                                                    @error('last_name')
                                                                        <span class="invalid-feedback" role="alert">
                                                                            <strong>{{ $message }}</strong>
                                                                        </span>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label
                                                                    class="col-md-3 col-from-label">{{ translate('Email') }}
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8">
                                                                    <input id="email" type="email"
                                                                        class="form-control @error('email') is-invalid @enderror"
                                                                        name="email"
                                                                        placeholder="{{ translate('Email') }}"
                                                                        value="{{ old('email') }}" required>
                                                                    <small class="form-text text-muted">Accepted Email:
                                                                        Gmail, Microsoft, and Yahoo Only</small>
                                                                    @error('email')
                                                                        <span class="invalid-feedback" role="alert">
                                                                            <strong>{{ $message }}</strong>
                                                                        </span>
                                                                    @enderror
                                                                </div>
                                                            </div>


                                                            <div class="form-group row">
                                                                <label
                                                                    class="col-md-3 col-from-label">{{ translate('Phone No.') }}
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8">
                                                                    <input id="phone" type="tel"
                                                                        class="form-control @error('phone') is-invalid @enderror"
                                                                        name="phone"
                                                                        placeholder="{{ translate('Phone No.') }}"
                                                                        pattern="[0-9]{11}"
                                                                        title="Please enter a valid 11-digit phone number"
                                                                        value="{{ old('phone') }}" required>
                                                                    @error('phone')
                                                                        <span class="invalid-feedback" role="alert">
                                                                            <strong>{{ $message }}</strong>
                                                                        </span>
                                                                    @enderror
                                                                    <small class="form-text text-muted">Format:
                                                                        09053456789</small>
                                                                </div>
                                                            </div>

                                                            {{-- Region --}}
                                                            @if ($geographicLevel == 4)
                                                                <div class="form-group row" id="region_group">
                                                                    <label class="col-md-3 col-from-label">Region</label>
                                                                    <div class="col-md-8">
                                                                        <select id="region_select" name="selected_region"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select Region') }}</option>
                                                                            @foreach ($regions as $region)
                                                                                <option value="{{ $region->id }}">
                                                                                    {{ $region->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @error('selected_region')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif


                                                            {{-- Province --}}
                                                            @if ($geographicLevel >= 2 && $geographicLevel <= 3)
                                                                <div class="form-group row" id="state_group">
                                                                    <label class="col-md-3 col-from-label">Province</label>
                                                                    <div class="col-md-8">
                                                                        <select id="state_select" name="selected_state"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select Province') }}</option>
                                                                            @foreach ($states as $state)
                                                                                <option value="{{ $state->id }}">
                                                                                    {{ $state->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @error('selected_state')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            {{-- City --}}
                                                            @if ($geographicLevel >= 1 && $geographicLevel <= 2)
                                                                <div class="form-group row" id="city_group">
                                                                    <label class="col-md-3 col-from-label">City</label>
                                                                    <div class="col-md-8">
                                                                        <select id="city_select" name="selected_city"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select City') }}</option>
                                                                            @foreach ($cities as $city)
                                                                                <option value="{{ $city->id }}">
                                                                                    {{ $city->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @error('selected_city')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            {{-- Barangay --}}
                                                            @if ($geographicLevel == 1)
                                                                <div class="form-group row" id="barangay_group">
                                                                    <label class="col-md-3 col-from-label">Barangay</label>
                                                                    <div class="col-md-8">
                                                                        <select id="barangay_select"
                                                                            name="selected_barangay"
                                                                            class="form-control aiz-selectpicker"
                                                                            data-live-search="true" required>
                                                                            <option value="">
                                                                                {{ translate('Select Barangay') }}</option>
                                                                            @foreach ($barangays as $barangay)
                                                                                <option value="{{ $barangay->id }}">
                                                                                    {{ $barangay->name }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @error('selected_barangay')
                                                                            <small
                                                                                class="text-danger d-block mt-1">{{ $message }}</small>
                                                                        @enderror
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            {{-- <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Membership Package') }}
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8">
                                                                    <select id="mempckge_select"
                                                                        class="form-control aiz-selectpicker"
                                                                        name="membership" required>
                                                                        <option value="" disabled selected>
                                                                            {{ translate('Select Package') }}</option>
                                                                        @foreach ($packages as $package)
                                                                            <option value="{{ $package->id }}"
                                                                                {{ request('mempckge') == $package->id ? 'selected' : '' }}>
                                                                                {{ $package->name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                            </div> --}}

                                                            {{-- Membership --}}
                                                            <div class="form-group row">
                                                                <label
                                                                    class="col-md-3 col-from-label">{{ translate('Membership Package') }}
                                                                    <span class="text-danger">*</span></label>
                                                                <div class="col-md-8">
                                                                    <select id="mempckge_select"
                                                                        class="form-control aiz-selectpicker"
                                                                        name="membership" required>
                                                                        <option value="" disabled
                                                                            {{ old('membership', request('mempckge')) ? '' : 'selected' }}>
                                                                            {{ translate('Select Package') }}
                                                                        </option>
                                                                        @foreach ($packages as $package)
                                                                            <option value="{{ $package->id }}"
                                                                                {{ (string) old('membership', request('mempckge')) === (string) $package->id ? 'selected' : '' }}>
                                                                                {{ $package->name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                    @error('membership')
                                                                        <small
                                                                            class="text-danger d-block mt-1">{{ $message }}</small>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Password') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8 position-relative ">
                                                                    <div class="input-group">
                                                                        <input id="password" type="password"
                                                                            class="form-control @error('password') is-invalid @enderror"
                                                                            name="password" value="{{ old('password') }}"
                                                                            required
                                                                            placeholder="{{ translate('Password') }}">
                                                                        <div class="input-group-append">
                                                                            <a type="button"
                                                                                class="btn btn-outline-secondary toggle-password"
                                                                                onclick="togglePassword('password', this)">
                                                                                <i class="las la-eye"></i>
                                                                            </a>
                                                                        </div>

                                                                        @error('password')
                                                                            <span class="invalid-feedback" role="alert">
                                                                                <strong>{{ $message }}</strong>
                                                                            </span>
                                                                        @enderror

                                                                    </div>
                                                                    <small class="form-text text-muted">Min 6 and max 20
                                                                        characters</small>
                                                                </div>
                                                            </div>

                                                            <!-- Confirm Password -->
                                                            <div class="form-group row">
                                                                <label class="col-md-3 col-from-label">
                                                                    {{ translate('Confirm Password') }} <span
                                                                        class="text-danger">*</span>
                                                                </label>
                                                                <div class="col-md-8 position-relative">
                                                                    <input id="confirm_password" type="password"
                                                                        class="form-control @error('password_confirmation') is-invalid @enderror"
                                                                        name="password_confirmation" required
                                                                        placeholder="{{ translate('Confirm Password') }}">

                                                                    @error('password_confirmation')
                                                                        <span class="invalid-feedback" role="alert">
                                                                            <strong>{{ $message }}</strong>
                                                                        </span>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="mar-all text-center mb-3">
                                                <button type="submit" class="btn btn-primary"
                                                    id="register-seller">{{ translate('Register') }}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        var jq = jQuery.noConflict();
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var baseUrl = '{{ URL::to('/') }}';
            var geographicLevel = {{ (int) $geographicLevel }};
            var mempckgeSelect = document.getElementById('mempckge_select');

            var citySelect = document.getElementById('city_select');
            var barangaySelect = document.getElementById('barangay_select');

            function loadCitiesLevel1() {
                if (!citySelect || !mempckgeSelect) return;
                var mempckge = mempckgeSelect.value;
                citySelect.innerHTML =
                    "<option value='' selected disabled>{{ translate('Select City') }}</option>";
                if (barangaySelect) {
                    barangaySelect.innerHTML =
                        "<option value='' selected disabled>{{ translate('Select Barangay') }}</option>";
                }

                // no stateId in URL — controller now supports this for level 1
                fetch(`${baseUrl}/api/get-cities?mempckge=${mempckge}`)
                    .then(r => r.json())
                    .then(data => {
                        if (data.cities && data.cities.length) {
                            data.cities.forEach(city => {
                                let opt = document.createElement("option");
                                opt.value = city.id;
                                opt.textContent = city.name;
                                citySelect.appendChild(opt);
                            });
                            jq('.aiz-selectpicker').selectpicker('refresh');
                        }
                    })
                    .catch(err => console.error("Error fetching cities (L1):", err));
            }

            function loadBarangays(cityId) {
                if (!barangaySelect || !mempckgeSelect) return;
                var mempckge = mempckgeSelect.value;
                barangaySelect.innerHTML =
                    "<option value='' selected disabled>{{ translate('Select Barangay') }}</option>";
                if (!cityId) return;

                fetch(`${baseUrl}/api/get-barangays/${cityId}?mempckge=${mempckge}`)
                    .then(r => r.json())
                    .then(data => {
                        if (data.barangays && data.barangays.length) {
                            data.barangays.forEach(b => {
                                let opt = document.createElement("option");
                                opt.value = b.id;
                                opt.textContent = b.name;
                                barangaySelect.appendChild(opt);
                            });
                            jq('.aiz-selectpicker').selectpicker('refresh');
                        }
                    })
                    .catch(err => console.error("Error fetching barangays:", err));
            }

            // Bind barangay loader on city change (works for level 1 and 2)
            if (citySelect) {
                citySelect.addEventListener('change', function() {
                    loadBarangays(this.value);
                });
            }

            // If this page is already loaded with a selected package at level 1,
            // auto-populate the cities (no Province in the UI).
            if (geographicLevel === 1) {
                loadCitiesLevel1();
            }

            // Keep your existing "reload page when membership changes" code as-is…
            if (mempckgeSelect) {
                mempckgeSelect.addEventListener('change', function() {
                    const mempckge = this.value;
                    const params = new URLSearchParams(window.location.search);
                    params.set('mempckge', mempckge);

                    const sellerIdEl = document.getElementById('sellerid');
                    if (sellerIdEl && sellerIdEl.value) params.set('sellerid', sellerIdEl.value);

                    window.location = `${baseUrl}/membership-registration?${params.toString()}`;
                });
            }
        });
    </script>
@endsection
