<?php

use App\Addons\Multivendor\Http\Controllers\Seller\PlaceOrderController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\InvoiceController;
use App\Addons\Multivendor\Http\Controllers\Seller\SellerController;
use App\Addons\Multivendor\Http\Controllers\Seller\CommissionController;
use App\Addons\Multivendor\Http\Controllers\Seller\SellerPayoutController;
use App\Addons\Multivendor\Http\Controllers\Seller\SellerPackageController;
use App\Addons\Multivendor\Http\Controllers\Admin\ShopController as AdminShopController;
use App\Addons\Multivendor\Http\Controllers\Admin\SellerController as AdminSellerController;
use App\Addons\Multivendor\Http\Controllers\Admin\CommissionController as AdminCommissionController;
use App\Addons\Multivendor\Http\Controllers\Admin\SellerPayoutController as AdminSellerPayoutController;
use App\Addons\Multivendor\Http\Controllers\Admin\SellerPackageController as AdminSellerPackageController;


/*
|--------------------------------------------------------------------------
| Seller Routes
|--------------------------------------------------------------------------
|
| Here is where you can register seller routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group([
  'prefix' => 'seller',
  'middleware' => ['auth', 'seller'],
  'as' => 'seller.'
], function () {

  Route::get('/', [SellerController::class, 'seller_dashboard'])->name('dashboard');
  Route::get('/profile', [SellerController::class, 'profile'])->name('profile');
  Route::post('/profile/update', [SellerController::class, 'profile_update'])->name('profile.update');

  // Seller products
  Route::group(['prefix' => 'product'], function () {
    Route::get('', [SellerController::class, 'seller_products_list'])->name('products');
    Route::get('/{id}', [SellerController::class, 'seller_product_show'])->name('product.show');
    Route::post('/published', [SellerController::class, 'seller_product_published'])->name('product.published');
  });

  // Seller packages
  Route::get('/select-package', [SellerPackageController::class, 'select_package'])->name('package_select');
  Route::post('/packages/purchase', [SellerPackageController::class, 'package_purchase'])->name('packages.purchase');
  Route::get('/packages/purchase-history', [SellerPackageController::class, 'package_purchase_history'])->name('package_purchase_history');
  Route::post('/packages/package_purchase_modal', [SellerPackageController::class, 'package_purchase_modal'])->name('package.package_purchase_modal'); // trek
  Route::post('/packages/package_purchase_confirm', [SellerPackageController::class, 'package_purchase_store'])->name('package.package_purchase_confirm'); // trek
  Route::post('/packages/package_payment_modal', [SellerPackageController::class, 'package_payment_modal'])->name('package.package_payment_modal'); // trek
  Route::post('/package-payment-proof-upload', [SellerPackageController::class, 'package_payment_proof'])->name('package.package_payment_proof'); //trek

  // Orders
  Route::get('/orders', [SellerController::class, 'orders'])->name('orders');
  Route::get('/orders/show/{id}', [SellerController::class, 'orders_show'])->name('orders_show');
  Route::get('/orders/print/{order_id}', [InvoiceController::class, 'invoice_print'])->name('orders.invoice.print');
  Route::get('/orders/invoice/{order_id}', [InvoiceController::class, 'seller_invoice_download'])->name('orders.invoice.download');
  Route::post('/orders/update_delivery_status', [OrderController::class, 'update_delivery_status'])->name('orders.update_delivery_status');
  Route::post('/orders/update_payment_status', [OrderController::class, 'update_payment_status'])->name('orders.update_payment_status');
  Route::post('/orders/add-tracking-information', [OrderController::class, 'add_tracking_information'])->name('orders.add_tracking_information');

  //POS orders
  Route::get('/my_orders', [PlaceOrderController::class, 'my_orders'])->name('my_orders');
  Route::get('/my_orders/place_order', [PlaceOrderController::class, 'place_order'])->name('place_order');
  Route::get('/my_orders/products', [PlaceOrderController::class, 'search'])->name('search_product');
  Route::post('/add-to-cart-pos', [PlaceOrderController::class, 'addToCart'])->name('addToCart');
  Route::post('/update-quantity-cart-pos', [PlaceOrderController::class, 'updateQuantity'])->name('updateQuantity');
  Route::post('/remove-from-cart-pos', [PlaceOrderController::class, 'removeFromCart'])->name('removeFromCart');
  Route::post('/setDiscount', [PlaceOrderController::class, 'setDiscount'])->name('setDiscount');
  Route::post('/pos-order-summary', [PlaceOrderController::class, 'get_order_summary'])->name('getOrderSummary');
  Route::post('/pos-order', [PlaceOrderController::class, 'order_store'])->name('order_place');
  Route::post('/store-shipping', [PlaceOrderController::class, 'store_shipping'])->name('store_shipping');

  //Referrals
  Route::get('/referrals/referrals', [SellerController::class, 'referrals'])->name('referrals');

  // Seller payouts
  Route::post('/payouts/store-request', [SellerPayoutController::class, 'store_withdraw_request'])->name('payouts.request.store');
  Route::get('/payouts/request', [SellerPayoutController::class, 'payout_requests'])->name('payouts.request');
  Route::resource('/payouts', SellerPayoutController::class)->names('payouts');
  Route::get('/payout-settings', [SellerPayoutController::class, 'payout_settings'])->name('payout_settings');
  Route::post('/payout-settings/update', [SellerPayoutController::class, 'payout_settings_update'])->name('payout_settings.update');
  Route::get('/commission-log', [CommissionController::class, 'commission_history'])->name('commission_log.index');

  // Route::get('/payment-upload', [SellerController::class, 'payment_proof_upload'])->name('new_seller_payment_upload'); // trek
  // Route::post('/seller/payment-upload-modal', [SellerController::class, 'payment_upload_modal'])->name('payment_upload_modal'); // trek
  // Route::post('/seller/payment-proof-upload', [SellerController::class, 'upload_payment_proof'])->name('new_seller_payment_upload_proof'); //trek

  // Payment upload page (GET)
  Route::get('/payment-upload', [SellerController::class, 'payment_proof_upload'])
    ->name('new_seller_payment_upload'); // => name is seller.new_seller_payment_upload

  // Modal + upload (POST) — remove the extra /seller in the URI
  Route::post('/payment-upload-modal', [SellerController::class, 'payment_upload_modal'])
    ->name('payment_upload_modal'); // => seller.payment_upload_modal

  Route::post('/payment-proof-upload', [SellerController::class, 'upload_payment_proof'])
    ->name('new_seller_payment_upload_proof'); // => seller.new_seller_payment_upload_proof
});

Route::group([
  'prefix' => 'admin',
  'middleware' => ['auth', 'admin'],
  'as' => 'admin.'
], function () {
  Route::get('/all-sellers', [AdminSellerController::class, 'all_sellers'])->name('all_sellers');
  Route::get('/seller-create', [AdminSellerController::class, 'seller_create'])->name('seller.create');
  Route::post('/seller-store', [AdminSellerController::class, 'seller_store'])->name('seller.store');
  Route::get('/seller-edit/{id}', [AdminSellerController::class, 'seller_edit'])->name('seller.edit');
  Route::post('/seller-update', [AdminSellerController::class, 'seller_update'])->name('seller.update');
  Route::post('/sellers/approval', [AdminSellerController::class, 'update_seller_approval'])->name('sellers.approval');
  Route::post('/shop/publish', [AdminSellerController::class, 'update_shop_publish'])->name('shop.publish');
  Route::post('/sellers/profile_modal', [AdminSellerController::class, 'profile_modal'])->name('sellers.profile_modal');
  Route::post('/sellers/payment_modal', [AdminSellerController::class, 'payment_modal'])->name('sellers.payment_modal');
  Route::get('/sellers/destroy/{id}', [AdminSellerController::class, 'seller_destroy'])->name('seller.destroy');
  Route::get('/sellers/login/{id}', [AdminSellerController::class, 'login_as_seller'])->name('seller.login_as_seller');

  // start seller verification form
  Route::get('/sellers/verification-form', [AdminSellerController::class, 'seller_verification_form'])->name('seller_verification_form');
  Route::post('/sellers/verification-form', [AdminSellerController::class, 'seller_verification_form_update'])->name('seller_verification_form_update');
  Route::get('/sellers/verification/{id}', [AdminSellerController::class, 'show_verification_request'])->name('show_verification_request');
  Route::get('/sellers/approve/{id}', [AdminSellerController::class, 'approve_seller'])->name('sellers.approve');
  Route::get('/sellers/reject/{id}', [AdminSellerController::class, 'reject_seller'])->name('sellers.reject');
  Route::get('/seller-products', [AdminSellerController::class, 'seller_products'])->name('seller_products.index');




  //ADMIN - Seller order index  and show
  Route::get('/seller-orders', [AdminSellerController::class, 'seller_orders'])->name('seller_orders');
  Route::get('/seller-order/show/{id}', [AdminSellerController::class, 'seller_order_show'])->name('seller_order_show');






  Route::get('/sellers/payout-requests', [AdminSellerPayoutController::class, 'payout_requests'])->name('all_payout_requests');
  Route::post('/sellers/payout_request/payment_modal', [AdminSellerPayoutController::class, 'payment_modal'])->name('payout_request.payment_modal');
  Route::post('/pay_to_seller', [AdminSellerPayoutController::class, 'pay_to_seller'])->name('pay_to_seller');
  Route::get('/sellers/payout-history', [AdminSellerPayoutController::class, 'index'])->name('seller_payments_history');
  Route::get('/sellers/commission-log', [AdminCommissionController::class, 'commission_history'])->name('commission_log.index');

  // Seller package
  Route::resource('seller-packages', AdminSellerPackageController::class)->names('seller_packages');
  Route::get('/seller-packages/edit/{id}', [AdminSellerPackageController::class, 'edit'])->name('seller_packages.edit');
  Route::get('/seller-packages/destroy/{id}', [AdminSellerPackageController::class, 'destroy'])->name('seller_packages.destroy');
  Route::get('/seller/package-payments', [AdminSellerPackageController::class, 'package_purchase_history'])->name('package_purchase_history');
  Route::post('/sellers/seller_package/package_payment_modal', [AdminSellerPackageController::class, 'package_payment_modal'])->name('seller_packages.package_payment_modal'); // trek
  Route::post('/package_payment_approval', [AdminSellerPackageController::class, 'package_payment_approval'])->name('package_payment_approval'); //trek
  Route::get('/shop-setting', [AdminShopController::class, 'shop_setting'])->name('shop_setting.index');
  Route::patch('/shop-setting/{id}', [AdminShopController::class, 'shop_setting_update'])->name('shop_setting.update');
});


Route::get('/copy-and-share-link', [SellerController::class, 'linkCopied'])->name('link.copied');
