<?php

use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Route;

Route::post('signup', [HomeController::class, 'signup'])->name('signup');
Route::get('/api/get-states', [HomeController::class, 'getStates']);
Route::get('/api/get-cities/{stateId?}', [HomeController::class, 'getCities']);
Route::get('/api/get-barangays/{cityId}', [HomeController::class, 'getBarangays']);
Route::get('/api/get-regions', [HomeController::class, 'getRegions']);
Route::get('/membership-registration', [HomeController::class, 'membershipregistration'])->name('membership-registration');
Route::get('/thank-you-for-registration', [HomeController::class, 'thankyouforregistration'])->name('thank-you-for-registration');

Route::get('/', function () {
  if ($user = auth()->user()) {
    if ($user->user_type === 'seller' && (int)$user->approval === 0) {
      return redirect()->route('seller.new_seller_payment_upload')
        ->with('status', 'Your account is pending approval.');
    }
    return match ($user->user_type) {
      'admin', 'staff' => redirect()->route('admin.dashboard'),
      'seller'         => redirect()->route('seller.dashboard'),
      default          => redirect('/'),
    };
  }
  return redirect('/login');
})->name('home');
